package com.ejie.ab04b.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab04b.constantes.Constantes;
import com.ejie.ab04b.constantes.ConstantesNum;
import com.ejie.ab04b.constantes.Secuencias;
import com.ejie.ab04b.dao.comun.UtilDAO;
import com.ejie.ab04b.model.ComunicacionApertura;
import com.ejie.ab04b.model.DatosNotificacion;
import com.ejie.ab04b.model.Obra;
import com.ejie.ab04b.model.TipoApertura;
import com.ejie.ab04b.model.nora.Municipio;
import com.ejie.ab04b.model.nora.Provincia;
import com.ejie.ab04b.util.Utilities;
import com.ejie.x38.dao.RowNumResultSetExtractor;
import com.ejie.x38.dto.JQGridManager;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * ComunicacionAperturaDaoImpl generated by UDA, 26-dic-2016 13:08:26.
 * 
 * @author UDA
 */

@Repository()
@Transactional()
public class ComunicacionAperturaDaoImpl implements ComunicacionAperturaDao {

	private JdbcTemplate jdbcTemplate;

	private static final String DATE_PATTERN_YEAR = "yyyy";

	private static final String QUERY_SELECT = "SELECT t1.ANOAPE_056 ANOAPE056, t1.NUMAPE_056 NUMAPE056, t1.FECPRE_056 FECPRE056, t1.FECIER_056 FECIER056, t1.NUEVA_056 NUEVA056, t1.TIPDOC_056 TIPDOC056, t1.NUMDOC_056 NUMDOC056, t1.NOMEMP_056 NOMEMP056, t1.PRVEMP_056 PRVEMP056, t1.MUNEMP_056 MUNEMP056, t1.DMUNEMP_056 DMUNEMP056, t1.DIREMP_056 DIREMP056, t1.CPOEMP_056 CPOEMP056, t1.TLFEMP_056 TLFEMP056, t1.CNAEEMP_056 CNAEEMP056, t1.ENTIAT_056 ENTIAT056, t1.TIPAPE_056 TIPAPE056, t1.NOMCTR_056 NOMCTR056, t1.PRVCTR_056 PRVCTR056, t1.MUNCTR_056 MUNCTR056, t1.LOCCTR_056 LOCCTR056, t1.DIRCTR_056 DIRCTR056, t1.CPOCTR_056 CPOCTR056, t1.TLFCTR_056 TLFCTR056, t1.FAXCTR_056 FAXCTR056, t1.EMAILCTR_056 EMAILCTR056, t1.CNAECTR_056 CNAECTR056, t1.PRVSS_056 PRVSS056, t1.NUMSS_056 NUMSS056, t1.DIGSS_056 DIGSS056, t1.FECINI_056 FECINI056, t1.TRBHOM_056 TRBHOM056, t1.TRBMUJ_056 TRBMUJ056, t1.TRBTOT_056 TRBTOT056, t1.CLASCTR_056 CLASCTR056, t1.DESCOBR_056 DESCOBR056, t1.SUPERF_056 SUPERF056, t1.PLANSEG_056 PLANSEG056, t1.CANALPLAN_056 CANALPLAN056, t1.PLANPRES_056 PLANPRES056, t1.PROYTEC_056 PROYTEC056, t1.DESCMAQ_056 DESCMAQ056, t1.POTEN_056 POTEN056, t1.INDANX_056 INDANX056, t1.APDOANX_056 APDOANX056, t1.DESTRAB_056 DESTRAB056, t1.INDOBRA_056 INDOBRA056, t1.CODOBRA_056 CODOBRA056, t1.CODCTR_056 CODCTR056, t1.LOTEMNT_056 LOTEMNT056, t1.VISOSL_056 VISOSL056, t1.ASGOSL_056 ASGOSL056, t1.TECOSL_056 TECOSL056, t1.FVISOSL_056 FVISOSL056, t1.VISINS_056 VISINS056, t1.ASGINS_056 ASGINS056, t1.TECINS_056 TECINS056, t1.FVISINS_056 FVISINS056, t1.FECINSP_056 FECINSP056, t1.FECREQ_056 FECREQ056, t1.FECSUB_056 FECSUB056, t1.FINFOSL_056 FINFOSL056, t1.FINFINSP_056 FINFINSP056, t1.FECALT_056 FECALT056, t1.USUALT_056 USUALT056, t1.FECMOD_056 FECMOD056, t1.USUMOD_056 USUMOD056, t1.DOCCORRECTA_056 DOCCORRECTA056, t1.CODENTIAT_056 CODENTIAT056, t1.ESTADOCIER_056 ESTADOCIER056, t1.ESTADO_056 ESTADO056, t1.CNAECTR93_056 CNAECTR93056, t1.CNAEEMP93_056 CNAEEMP93056, t1.MODPRE_056 MODPRE056, t1.NUMCNT_056 NUMCNT056, t1.IDAPE_056 IDAPE056, t1.EVALPRES_056 EVALPRES056, t1.CANALEVAL_056 CANALEVAL056, t1.REGEMP_056 REGEMP056, t1.NUMDOCREPRESENTANTE_056 NUMDOCREPRESENTANTE056,t1.NOMREPRESENTANTE_056 NOMREPRESENTANTE056,t1.TIPDOCREPRESENTANTE_056 TIPDOCREPRESENTANTE056, t1.TLFREPRESENTANTE_056 TLFREPRESENTANTE056, t1.TERAPE_056 TERAPE056, t1.FORPRE_056 FORPRE056, t1.FOLDER_ID_056 FOLDERID056, t1.PAISEMP_056 PAISEMP056, t1.COD_DATOS_NOTIF_056 CODDATOSNOTIF056, t1.MIGRADO_056 MIGRADO056, t1.MAIL_CONTACTO_SOLIC_056 MAILCONTACTOSOLIC056,  t1.TELEF_CONTACTO_SOLIC_056 TELEFCONTACTOSOLIC056, t1.RAZON_SOCIAL_ANT_056 RAZONSOCIALANT056, t1.DIRECC_ANT_056 DIRECCANT056, t1.FEC_FIN_PLAZO_056 FECFINPLAZO056, t1.USUARIO_APE_056 USUARIOAPE056, t1.USUARIO_APORT_056 USUARIOAPORT056, t1.USUARIO_TRAM_056 USUARIOTRAM056 ";

	private static final String QUERY_SELECT3 = "SELECT  t1.ANOAPE_056 ANOAPE056, t1.NUMAPE_056 NUMAPE056, t1.FECPRE_056 FECPRE056, t1.FECIER_056 FECIER056, t1.NUEVA_056 NUEVA056, t1.TIPDOC_056 TIPDOC056, t1.NUMDOC_056 NUMDOC056, t1.NOMEMP_056 NOMEMP056, t1.PRVEMP_056 PRVEMP056, t1.MUNEMP_056 MUNEMP056, t1.DMUNEMP_056 DMUNEMP056, t1.DIREMP_056 DIREMP056, t1.CPOEMP_056 CPOEMP056, t1.TLFEMP_056 TLFEMP056, t1.CNAEEMP_056 CNAEEMP056, t1.ENTIAT_056 ENTIAT056, t1.TIPAPE_056 TIPAPE056, t1.NOMCTR_056 NOMCTR056, t1.PRVCTR_056 PRVCTR056, t1.MUNCTR_056 MUNCTR056, t1.LOCCTR_056 LOCCTR056, t1.DIRCTR_056 DIRCTR056, t1.CPOCTR_056 CPOCTR056, t1.TLFCTR_056 TLFCTR056, t1.FAXCTR_056 FAXCTR056, t1.EMAILCTR_056 EMAILCTR056, t1.CNAECTR_056 CNAECTR056, t1.PRVSS_056 PRVSS056, t1.NUMSS_056 NUMSS056, t1.DIGSS_056 DIGSS056, t1.FECINI_056 FECINI056, t1.TRBHOM_056 TRBHOM056, t1.TRBMUJ_056 TRBMUJ056, t1.TRBTOT_056 TRBTOT056, t1.CLASCTR_056 CLASCTR056, t1.DESCOBR_056 DESCOBR056, t1.SUPERF_056 SUPERF056, t1.PLANSEG_056 PLANSEG056, t1.CANALPLAN_056 CANALPLAN056, t1.PLANPRES_056 PLANPRES056, t1.PROYTEC_056 PROYTEC056, t1.DESCMAQ_056 DESCMAQ056, t1.POTEN_056 POTEN056, t1.INDANX_056 INDANX056, t1.APDOANX_056 APDOANX056, t1.DESTRAB_056 DESTRAB056, t1.INDOBRA_056 INDOBRA056, t1.CODOBRA_056 CODOBRA056, t1.CODCTR_056 CODCTR056, t1.LOTEMNT_056 LOTEMNT056, t1.VISOSL_056 VISOSL056, t1.ASGOSL_056 ASGOSL056, t1.TECOSL_056 TECOSL056, t1.FVISOSL_056 FVISOSL056, t1.VISINS_056 VISINS056, t1.ASGINS_056 ASGINS056, t1.TECINS_056 TECINS056, t1.FVISINS_056 FVISINS056, t1.FECINSP_056 FECINSP056, t1.FECREQ_056 FECREQ056, t1.FECSUB_056 FECSUB056, t1.FINFOSL_056 FINFOSL056, t1.FINFINSP_056 FINFINSP056, t1.FECALT_056 FECALT056, t1.USUALT_056 USUALT056, t1.FECMOD_056 FECMOD056, t1.USUMOD_056 USUMOD056, t1.DOCCORRECTA_056 DOCCORRECTA056, t1.CODENTIAT_056 CODENTIAT056, t1.ESTADOCIER_056 ESTADOCIER056, t1.ESTADO_056 ESTADO056, t1.CNAECTR93_056 CNAECTR93056, t1.CNAEEMP93_056 CNAEEMP93056, t1.MODPRE_056 MODPRE056, t1.NUMCNT_056 NUMCNT056, t1.IDAPE_056 IDAPE056, t1.EVALPRES_056 EVALPRES056, t1.CANALEVAL_056 CANALEVAL056, t1.REGEMP_056 REGEMP056, t1.NUMDOCREPRESENTANTE_056 NUMDOCREPRESENTANTE056,t1.NOMREPRESENTANTE_056 NOMREPRESENTANTE056,t1.TIPDOCREPRESENTANTE_056 TIPDOCREPRESENTANTE056, t1.TLFREPRESENTANTE_056 TLFREPRESENTANTE056, t1.TERAPE_056 TERAPE056, t1.FORPRE_056 FORPRE056, t1.FOLDER_ID_056 FOLDERID056, t1.PAISEMP_056 PAISEMP056, t1.COD_DATOS_NOTIF_056 CODDATOSNOTIF056, t1.MIGRADO_056 MIGRADO056, t1.MAIL_CONTACTO_SOLIC_056 MAILCONTACTOSOLIC056,  t1.TELEF_CONTACTO_SOLIC_056 TELEFCONTACTOSOLIC056, t1.RAZON_SOCIAL_ANT_056 RAZONSOCIALANT056, t1.DIRECC_ANT_056 DIRECCANT056, t1.FEC_FIN_PLAZO_056 FECFINPLAZO056, t1.USUARIO_APE_056 USUARIOAPE056, t1.USUARIO_APORT_056 USUARIOAPORT056, t1.USUARIO_TRAM_056 USUARIOTRAM056 ,t2.CODOBRA_082 CODOBRA082, t2.TIPOBR_082 TIPOBR082, t2.INDANX2_082 INDANX2082, t2.APDOANX2_082 APDOANX2082, t2.DESTRAB_082 DESTRAB082, t2.PRVOBR_082 PRVOBR082, t2.MUNOBR_082 MUNOBR082, t2.LOCOBR_082 LOCOBR082, t2.DIROBR_082 DIROBR082, t2.FECINI_082 FECINI082, t2.FECFIN_082 FECFIN082, t2.TEREXP_082 TEREXP082, t2.ANOEXP_082 ANOEXP082, t2.NUMEXP_082 NUMEXP082, t2.ORDEXP_082 ORDEXP082, t2.FECALT_082 FECALT082, t2.USUALT_082 USUALT082, t2.FECMOD_082 FECMOD082, t2.USUMOD_082 USUMOD082, t2.DESCOBR_082 DESCOBR082, t2.DESOBR_082 DESOBR082, t2.DURPRE_082 DURPRE082, t2.UNITMP_082 UNITMP082, t2.TRBHOM_082 TRBHOM082, t2.TRBMUJ_082 TRBMUJ082, t2.TRBTOT_082 TRBTOT082 ";

	private static final String QUERY_SELECT_2 = "SELECT t1.ANOAPE_056 ANOAPE056, t1.NUMAPE_056 NUMAPE056, t1.TERAPE_056 TERAPE056 ";

	private static final String QUERY_SELECT_DATOS_REGISTRO = "SELECT t1.ANOAPE_056 ANOAPE056, t1.NUMAPE_056 NUMAPE056, t1.TERAPE_056 TERAPE056, t1.DESEA_REG_056 DESEAREG056, t1.NUM_REGISTRO_056 NUMREGISTRO056, t1.FEC_REGISTRO_056 FECREGISTRO056";

	/**
	 * Gets the jdbc template.
	 * 
	 * JdbcTemplate
	 * 
	 * @return the jdbc template
	 */
	public JdbcTemplate getJdbcTemplate() {
		return this.jdbcTemplate;
	}

	/*
	 * ROW_MAPPERS
	 */
	private RowMapper<ComunicacionApertura> rwMapSS = new RowMapper<ComunicacionApertura>() {
		public ComunicacionApertura mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			ComunicacionApertura comunicAperturaRet = new ComunicacionApertura();
			comunicAperturaRet.setPrvss056(resultSet.getString("PRVSS056"));
			comunicAperturaRet.setNumss056(resultSet.getString("NUMSS056"));
			comunicAperturaRet.setDigss056(resultSet.getString("DIGSS056"));

			return comunicAperturaRet;
		}
	};

	/*
	 * ROW_MAPPERS
	 */
	private RowMapper<ComunicacionApertura> rwMapRea = new RowMapper<ComunicacionApertura>() {
		public ComunicacionApertura mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			ComunicacionApertura comunicAperturaRet = new ComunicacionApertura();
			comunicAperturaRet.setRegemp056(resultSet.getString("REGEMP056"));

			return comunicAperturaRet;
		}
	};

	/*
	 * ROW_MAPPERS
	 */
	private RowMapper<ComunicacionApertura> rwMap = new RowMapper<ComunicacionApertura>() {
		public ComunicacionApertura mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			ComunicacionApertura comunicAperturaRet = new ComunicacionApertura(
					resultSet.getString("ANOAPE056"),
					resultSet.getLong("NUMAPE056"),
					resultSet.getTimestamp("FECPRE056"),
					resultSet.getDate("FECIER056"),
					resultSet.getString("NUEVA056"),
					resultSet.getString("TIPDOC056"),
					resultSet.getString("NUMDOC056"),
					resultSet.getString("NOMEMP056"),
					resultSet.getString("PAISEMP056"),
					new Provincia((resultSet.getString("PRVEMP056") != null
							&& resultSet.getString("PRVEMP056").length() == 1)
									? "0" + resultSet.getString("PRVEMP056")
									: resultSet.getString("PRVEMP056")),
					new Municipio((resultSet.getString("MUNEMP056") != null
							&& resultSet.getString("MUNEMP056")
									.length() < ConstantesNum.NUM_3)
											? "0"
													+ resultSet.getString(
															"MUNEMP056")
											: resultSet.getString("MUNEMP056")),
					resultSet.getString("DMUNEMP056"),
					resultSet.getString("DIREMP056"),
					resultSet.getString("CPOEMP056"),
					resultSet.getString("TLFEMP056"),
					resultSet.getString("CNAEEMP056"),
					resultSet.getString("ENTIAT056"),
					new TipoApertura(resultSet.getString("TIPAPE056")),
					resultSet.getString("NOMCTR056"),
					new Provincia((resultSet.getString("PRVCTR056") != null
							&& resultSet.getString("PRVCTR056").length() == 1)
									? "0" + resultSet.getString("PRVCTR056")
									: resultSet.getString("PRVCTR056")),
					new Municipio((resultSet.getString("MUNCTR056") != null
							&& resultSet.getString("MUNCTR056")
									.length() < ConstantesNum.NUM_3)
											? "0"
													+ resultSet.getString(
															"MUNCTR056")
											: resultSet.getString("MUNCTR056")),
					resultSet.getString("LOCCTR056"),
					resultSet.getString("DIRCTR056"),
					resultSet.getString("CPOCTR056"),
					resultSet.getString("TLFCTR056"),
					resultSet.getString("FAXCTR056"),
					resultSet.getString("EMAILCTR056"),
					resultSet.getString("CNAECTR056"),
					resultSet.getString("PRVSS056"),
					resultSet.getString("NUMSS056"),
					resultSet.getString("DIGSS056"),
					resultSet.getDate("FECINI056"),
					resultSet.getLong("TRBHOM056"),
					resultSet.getLong("TRBMUJ056"),
					resultSet.getLong("TRBTOT056"),
					resultSet.getString("CLASCTR056"),
					resultSet.getString("DESCOBR056"),
					resultSet.getInt("SUPERF056"),
					resultSet.getString("PLANSEG056"),
					resultSet.getString("CANALPLAN056"),
					resultSet.getString("PLANPRES056"),
					resultSet.getString("PROYTEC056"),
					resultSet.getString("DESCMAQ056"),
					resultSet.getBigDecimal("POTEN056"),
					resultSet.getString("INDANX056"),
					resultSet.getString("APDOANX056"),
					resultSet.getString("DESTRAB056"),
					resultSet.getString("INDOBRA056"),
					resultSet.getLong("CODOBRA056"),
					resultSet.getInt("CODCTR056"),
					resultSet.getString("LOTEMNT056"),
					resultSet.getString("VISOSL056"),
					resultSet.getString("ASGOSL056"),
					resultSet.getString("TECOSL056"),
					resultSet.getDate("FVISOSL056"),
					resultSet.getString("VISINS056"),
					resultSet.getString("ASGINS056"),
					resultSet.getString("TECINS056"),
					resultSet.getDate("FVISINS056"),
					resultSet.getDate("FECINSP056"),
					resultSet.getDate("FECREQ056"),
					resultSet.getDate("FECSUB056"),
					resultSet.getDate("FINFOSL056"),
					resultSet.getDate("FINFINSP056"),
					resultSet.getDate("FECALT056"),
					resultSet.getString("USUALT056"),
					resultSet.getDate("FECMOD056"),
					resultSet.getString("USUMOD056"),
					resultSet.getString("DOCCORRECTA056"),
					resultSet.getString("CODENTIAT056"),
					resultSet.getString("ESTADOCIER056"),
					resultSet.getString("ESTADO056"),
					resultSet.getString("CNAECTR93056"),
					resultSet.getString("CNAEEMP93056"),
					resultSet.getInt("MODPRE056"),
					resultSet.getLong("NUMCNT056"),
					resultSet.getLong("IDAPE056"),
					resultSet.getString("EVALPRES056"),
					resultSet.getString("CANALEVAL056"),
					resultSet.getString("REGEMP056"),
					resultSet.getString("NUMDOCREPRESENTANTE056"),
					resultSet.getString("NOMREPRESENTANTE056"),
					resultSet.getString("TIPDOCREPRESENTANTE056"),
					resultSet.getString("TLFREPRESENTANTE056"),
					resultSet.getString("TERAPE056"),
					resultSet.getString("FORPRE056"),
					resultSet.getString("FOLDERID056"),
					new DatosNotificacion(resultSet.getInt("CODDATOSNOTIF056")),
					resultSet.getString("MAILCONTACTOSOLIC056"),
					resultSet.getString("TELEFCONTACTOSOLIC056"),
					resultSet.getString("RAZONSOCIALANT056"),
					resultSet.getString("DIRECCANT056"),
					resultSet.getDate("FECFINPLAZO056"),
					resultSet.getString("USUARIOAPE056"),
					resultSet.getString("USUARIOAPORT056"),
					resultSet.getString("USUARIOTRAM056"));

			if (UtilDAO.hasColumn(resultSet, "PAISEMP056")) {
				comunicAperturaRet
						.setPaisemp056(resultSet.getString("PAISEMP056"));
			}
			if (UtilDAO.hasColumn(resultSet, "MIGRADO056")) {
				comunicAperturaRet
						.setMigrado056(resultSet.getString("MIGRADO056"));
			}
			return comunicAperturaRet;
		}
	};

	private RowMapper<ComunicacionApertura> rwMapPK = new RowMapper<ComunicacionApertura>() {
		public ComunicacionApertura mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new ComunicacionApertura(resultSet.getString("TERAPE056"),
					resultSet.getString("ANOAPE056"),
					resultSet.getLong("NUMAPE056"));
		}
	};

	private RowMapper<ComunicacionApertura> rwMapDatosRegistro = new RowMapper<ComunicacionApertura>() {
		public ComunicacionApertura mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			ComunicacionApertura apertura = new ComunicacionApertura(
					resultSet.getString("TERAPE056"),
					resultSet.getString("ANOAPE056"),
					resultSet.getLong("NUMAPE056"));

			apertura.setDeseaRegistrar(resultSet.getString("DESEAREG056"));
			apertura.setNumReg(resultSet.getString("NUMREGISTRO056"));
			apertura.setFecReg(resultSet.getDate("FECREGISTRO056"));

			return apertura;
		}
	};

	private RowMapper<ComunicacionApertura> rwMapReorder = new RowMapper<ComunicacionApertura>() {
		public ComunicacionApertura mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new ComunicacionApertura(resultSet.getString("TERAPE"),
					resultSet.getString("ANOAPE"), resultSet.getLong("NUMAPE"));
		}
	};

	private RowMapper<ComunicacionApertura> rwMap3 = new RowMapper<ComunicacionApertura>() {
		public ComunicacionApertura mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			ComunicacionApertura comunicAperturaRet = new ComunicacionApertura(
					resultSet.getString("ANOAPE056"),
					resultSet.getLong("NUMAPE056"),
					resultSet.getTimestamp("FECPRE056"),
					resultSet.getDate("FECIER056"),
					resultSet.getString("NUEVA056"),
					resultSet.getString("TIPDOC056"),
					resultSet.getString("NUMDOC056"),
					resultSet.getString("NOMEMP056"),
					resultSet.getString("PAISEMP056"),
					new Provincia((resultSet.getString("PRVEMP056") != null
							&& resultSet.getString("PRVEMP056").length() == 1)
									? "0" + resultSet.getString("PRVEMP056")
									: resultSet.getString("PRVEMP056")),
					new Municipio((resultSet.getString("MUNEMP056") != null
							&& resultSet.getString("MUNEMP056")
									.length() < ConstantesNum.NUM_3)
											? "0"
													+ resultSet.getString(
															"MUNEMP056")
											: resultSet.getString("MUNEMP056")),
					resultSet.getString("DMUNEMP056"),
					resultSet.getString("DIREMP056"),
					resultSet.getString("CPOEMP056"),
					resultSet.getString("TLFEMP056"),
					resultSet.getString("CNAEEMP056"),
					resultSet.getString("ENTIAT056"),
					new TipoApertura(resultSet.getString("TIPAPE056")),
					resultSet.getString("NOMCTR056"),
					new Provincia((resultSet.getString("PRVCTR056") != null
							&& resultSet.getString("PRVCTR056").length() == 1)
									? "0" + resultSet.getString("PRVCTR056")
									: resultSet.getString("PRVCTR056")),
					new Municipio((resultSet.getString("MUNCTR056") != null
							&& resultSet.getString("MUNCTR056")
									.length() < ConstantesNum.NUM_3)
											? "0"
													+ resultSet.getString(
															"MUNCTR056")
											: resultSet.getString("MUNCTR056")),
					resultSet.getString("LOCCTR056"),
					resultSet.getString("DIRCTR056"),
					resultSet.getString("CPOCTR056"),
					resultSet.getString("TLFCTR056"),
					resultSet.getString("FAXCTR056"),
					resultSet.getString("EMAILCTR056"),
					resultSet.getString("CNAECTR056"),
					resultSet.getString("PRVSS056"),
					resultSet.getString("NUMSS056"),
					resultSet.getString("DIGSS056"),
					resultSet.getDate("FECINI056"),
					resultSet.getLong("TRBHOM056"),
					resultSet.getLong("TRBMUJ056"),
					resultSet.getLong("TRBTOT056"),
					resultSet.getString("CLASCTR056"),
					resultSet.getString("DESCOBR056"),
					resultSet.getInt("SUPERF056"),
					resultSet.getString("PLANSEG056"),
					resultSet.getString("CANALPLAN056"),
					resultSet.getString("PLANPRES056"),
					resultSet.getString("PROYTEC056"),
					resultSet.getString("DESCMAQ056"),
					resultSet.getBigDecimal("POTEN056"),
					resultSet.getString("INDANX056"),
					resultSet.getString("APDOANX056"),
					resultSet.getString("DESTRAB056"),
					resultSet.getString("INDOBRA056"),
					resultSet.getLong("CODOBRA056"),
					resultSet.getInt("CODCTR056"),
					resultSet.getString("LOTEMNT056"),
					resultSet.getString("VISOSL056"),
					resultSet.getString("ASGOSL056"),
					resultSet.getString("TECOSL056"),
					resultSet.getDate("FVISOSL056"),
					resultSet.getString("VISINS056"),
					resultSet.getString("ASGINS056"),
					resultSet.getString("TECINS056"),
					resultSet.getDate("FVISINS056"),
					resultSet.getDate("FECINSP056"),
					resultSet.getDate("FECREQ056"),
					resultSet.getDate("FECSUB056"),
					resultSet.getDate("FINFOSL056"),
					resultSet.getDate("FINFINSP056"),
					resultSet.getDate("FECALT056"),
					resultSet.getString("USUALT056"),
					resultSet.getDate("FECMOD056"),
					resultSet.getString("USUMOD056"),
					resultSet.getString("DOCCORRECTA056"),
					resultSet.getString("CODENTIAT056"),
					resultSet.getString("ESTADOCIER056"),
					resultSet.getString("ESTADO056"),
					resultSet.getString("CNAECTR93056"),
					resultSet.getString("CNAEEMP93056"),
					resultSet.getInt("MODPRE056"),
					resultSet.getLong("NUMCNT056"),
					resultSet.getLong("IDAPE056"),
					resultSet.getString("EVALPRES056"),
					resultSet.getString("CANALEVAL056"),
					resultSet.getString("REGEMP056"),
					resultSet.getString("NUMDOCREPRESENTANTE056"),
					resultSet.getString("NOMREPRESENTANTE056"),
					resultSet.getString("TIPDOCREPRESENTANTE056"),
					resultSet.getString("TLFREPRESENTANTE056"),
					resultSet.getString("TERAPE056"),
					resultSet.getString("FORPRE056"),
					resultSet.getString("FOLDERID056"),
					new DatosNotificacion(resultSet.getInt("CODDATOSNOTIF056")),
					resultSet.getString("MAILCONTACTOSOLIC056"),
					resultSet.getString("TELEFCONTACTOSOLIC056"),
					resultSet.getString("RAZONSOCIALANT056"),
					resultSet.getString("DIRECCANT056"),
					resultSet.getDate("FECFINPLAZO056"),
					resultSet.getString("USUARIOAPE056"),
					resultSet.getString("USUARIOAPORT056"),
					new Obra(resultSet.getLong("CODOBRA082"),
							resultSet.getString("TIPOBR082"),
							resultSet.getString("INDANX2082"),
							resultSet.getString("APDOANX2082"),
							resultSet.getString("DESTRAB082"),
							resultSet.getString("PRVOBR082"),
							resultSet.getString("MUNOBR082"),
							resultSet.getString("LOCOBR082"),
							resultSet.getString("DIROBR082"),
							resultSet.getDate("FECINI082"),
							resultSet.getDate("FECFIN082"),
							resultSet.getString("TEREXP082"),
							resultSet.getString("ANOEXP082"),
							resultSet.getInt("NUMEXP082"),
							resultSet.getLong("ORDEXP082"),
							resultSet.getDate("FECALT082"),
							resultSet.getString("USUALT082"),
							resultSet.getDate("FECMOD082"),
							resultSet.getString("USUMOD082"),
							resultSet.getString("DESCOBR082"),
							resultSet.getString("DESOBR082"),
							resultSet.getString("DURPRE082"),
							resultSet.getString("UNITMP082"),
							resultSet.getLong("TRBHOM082"),
							resultSet.getLong("TRBMUJ082"),
							resultSet.getLong("TRBTOT082")),

					resultSet.getString("USUARIOTRAM056"));

			if (UtilDAO.hasColumn(resultSet, "PAISEMP056")) {
				comunicAperturaRet
						.setPaisemp056(resultSet.getString("PAISEMP056"));
			}
			if (UtilDAO.hasColumn(resultSet, "MIGRADO056")) {
				comunicAperturaRet
						.setMigrado056(resultSet.getString("MIGRADO056"));
			}
			return comunicAperturaRet;
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * dataSource DataSource
	 * 
	 * @param dataSource
	 *            the new data source
	 */
	@Resource()
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/*
	 * OPERACIONES CRUD
	 */

	/**
	 * Inserts a single row in the Ab04b56s00 table.
	 * 
	 * ab04b56s00 Ab04b56s00 Ab04b56s00
	 * 
	 * @param ab04b56s00
	 *            the ab 04 b 56 s 00
	 * @return the comunicacion apertura
	 */
	public ComunicacionApertura add(ComunicacionApertura ab04b56s00) {
		String query = "INSERT INTO AB0456S00 (ANOAPE_056, NUMAPE_056, FECPRE_056, FECIER_056, NUEVA_056, TIPDOC_056, NUMDOC_056, NOMEMP_056, PAISEMP_056, PRVEMP_056, MUNEMP_056, DMUNEMP_056, DIREMP_056, CPOEMP_056, TLFEMP_056, CNAEEMP_056, ENTIAT_056, TIPAPE_056, NOMCTR_056, PRVCTR_056, MUNCTR_056, LOCCTR_056, DIRCTR_056, CPOCTR_056, TLFCTR_056, FAXCTR_056, EMAILCTR_056, CNAECTR_056, PRVSS_056, NUMSS_056, DIGSS_056, FECINI_056, TRBHOM_056, TRBMUJ_056, TRBTOT_056, CLASCTR_056, DESCOBR_056, SUPERF_056, PLANSEG_056, CANALPLAN_056, PLANPRES_056, PROYTEC_056, DESCMAQ_056, POTEN_056, INDANX_056, APDOANX_056, DESTRAB_056, INDOBRA_056, CODOBRA_056, CODCTR_056, LOTEMNT_056, VISOSL_056, ASGOSL_056, TECOSL_056, FVISOSL_056, VISINS_056, ASGINS_056, TECINS_056, FVISINS_056, FECINSP_056, FECREQ_056, FECSUB_056, FINFOSL_056, FINFINSP_056, FECALT_056, USUALT_056, FECMOD_056, USUMOD_056, DOCCORRECTA_056, CODENTIAT_056, ESTADOCIER_056, ESTADO_056, CNAECTR93_056, CNAEEMP93_056, MODPRE_056, NUMCNT_056, IDAPE_056, EVALPRES_056, CANALEVAL_056, REGEMP_056, NUMDOCREPRESENTANTE_056,NOMREPRESENTANTE_056,TIPDOCREPRESENTANTE_056, TLFREPRESENTANTE_056, TERAPE_056, FORPRE_056, FOLDER_ID_056, COD_DATOS_NOTIF_056, MIGRADO_056,TIT_REPR_061) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";

		Integer codDatosNotificacion = null;
		if (ab04b56s00.getDatosNotificacion() != null) {
			codDatosNotificacion = ab04b56s00.getDatosNotificacion()
					.getCodDatosNotif066();
		}

		ab04b56s00.setAnoape056(new SimpleDateFormat(
				ComunicacionAperturaDaoImpl.DATE_PATTERN_YEAR)
						.format(new Date()));

		this.jdbcTemplate.update(query, ab04b56s00.getAnoape056(),
				ab04b56s00.getNumape056(), ab04b56s00.getFecpre056(),
				ab04b56s00.getFecier056(), ab04b56s00.getNueva056(),
				ab04b56s00.getTipdoc056(), ab04b56s00.getNumdoc056(),
				ab04b56s00.getNomemp056(), ab04b56s00.getPaisemp056(),
				ab04b56s00.getProvinciaEmp().getCodProvincia(),
				ab04b56s00.getMunicipioEmp().getCodMunicipio(),
				ab04b56s00.getDmunemp056(), ab04b56s00.getDiremp056(),
				ab04b56s00.getCpoemp056(), ab04b56s00.getTlfemp056(),
				ab04b56s00.getCnaeemp056(), ab04b56s00.getEntiat056(),
				ab04b56s00.getTipoApertura().getTipape071(),
				ab04b56s00.getNomctr056(),
				ab04b56s00.getProvinciaCtr().getCodProvincia(),
				ab04b56s00.getMunicipioCtr().getCodMunicipio(),
				ab04b56s00.getLocctr056(), ab04b56s00.getDirctr056(),
				ab04b56s00.getCpoctr056(), ab04b56s00.getTlfctr056(),
				ab04b56s00.getFaxctr056(), ab04b56s00.getEmailctr056(),
				ab04b56s00.getCnaectr056(), ab04b56s00.getPrvss056(),
				ab04b56s00.getNumss056(), ab04b56s00.getDigss056(),
				ab04b56s00.getFecini056(), ab04b56s00.getTrbhom056(),
				ab04b56s00.getTrbmuj056(), ab04b56s00.getTrbtot056(),
				ab04b56s00.getClasctr056(), ab04b56s00.getDescobr056(),
				ab04b56s00.getSuperf056(), ab04b56s00.getPlanseg056(),
				ab04b56s00.getCanalplan056(), ab04b56s00.getPlanpres056(),
				ab04b56s00.getProytec056(), ab04b56s00.getDescmaq056(),
				ab04b56s00.getPoten056(), ab04b56s00.getIndanx056(),
				ab04b56s00.getApdoanx056(), ab04b56s00.getDestrab056(),
				ab04b56s00.getIndobra056(), ab04b56s00.getCodobra056(),
				ab04b56s00.getCodctr056(), ab04b56s00.getLotemnt056(),
				ab04b56s00.getVisosl056(), ab04b56s00.getAsgosl056(),
				ab04b56s00.getTecosl056(), ab04b56s00.getFvisosl056(),
				ab04b56s00.getVisins056(), ab04b56s00.getAsgins056(),
				ab04b56s00.getTecins056(), ab04b56s00.getFvisins056(),
				ab04b56s00.getFecinsp056(), ab04b56s00.getFecreq056(),
				ab04b56s00.getFecsub056(), ab04b56s00.getFinfosl056(),
				ab04b56s00.getFinfinsp056(), ab04b56s00.getFecalt056(),
				ab04b56s00.getUsualt056(), ab04b56s00.getFecmod056(),
				ab04b56s00.getUsumod056(), ab04b56s00.getDoccorrecta056(),
				ab04b56s00.getCodentiat056(), ab04b56s00.getEstadocier056(),
				ab04b56s00.getEstado056(), ab04b56s00.getCnaectr93056(),
				ab04b56s00.getCnaeemp93056(), ab04b56s00.getModpre056(),
				ab04b56s00.getNumcnt056(), ab04b56s00.getIdape056(),
				ab04b56s00.getEvalpres056(), ab04b56s00.getCanaleval056(),
				ab04b56s00.getRegemp056(),
				ab04b56s00.getNumdocrepresentante056(),
				ab04b56s00.getNombrerepresentante056(),
				ab04b56s00.getTipdocrepresentante056(),
				ab04b56s00.getTlfrepresentante056(), ab04b56s00.getTerape056(),
				ab04b56s00.getForpre056(), ab04b56s00.getFolderId056(),
				codDatosNotificacion, ab04b56s00.getMigrado056(), "T");
		return ab04b56s00;
	}

	/**
	 * Inserts a single row in the Ab04b56s00 table.
	 * 
	 * apertura String ComunicacionApertura
	 * 
	 * @param apertura
	 *            the apertura
	 * @return the comunicacion apertura
	 */
	public ComunicacionApertura addFromSolicitudNumReg(
			ComunicacionApertura apertura) {
		String query = "INSERT INTO AB0456S00 (ANOAPE_056, NUMAPE_056, IDAPE_056, FECPRE_056, NUEVA_056, TIPDOC_056, NUMDOC_056, NOMEMP_056, PAISEMP_056, PRVEMP_056, MUNEMP_056, DMUNEMP_056, DIREMP_056, "
				+ "CPOEMP_056, TLFEMP_056, CNAEEMP_056, ENTIAT_056, TIPAPE_056, NOMCTR_056, PRVCTR_056, MUNCTR_056, LOCCTR_056, DIRCTR_056, CPOCTR_056, TLFCTR_056, FAXCTR_056, EMAILCTR_056, CNAECTR_056, "
				+ "PRVSS_056, NUMSS_056, DIGSS_056, FECINI_056, TRBHOM_056, TRBMUJ_056, TRBTOT_056, CLASCTR_056, DESCOBR_056, SUPERF_056, PLANSEG_056, CANALPLAN_056, PLANPRES_056, PROYTEC_056, "
				+ "DESCMAQ_056, POTEN_056, INDANX_056, APDOANX_056, DESTRAB_056, INDOBRA_056, CODOBRA_056, CODCTR_056, LOTEMNT_056, ASGOSL_056, "
				+ "FECALT_056, "
				+ "CODENTIAT_056, CNAECTR93_056, CNAEEMP93_056, MODPRE_056, NUMCNT_056, EVALPRES_056, CANALEVAL_056, REGEMP_056, NUMDOCREPRESENTANTE_056,NOMREPRESENTANTE_056,TIPDOCREPRESENTANTE_056, "
				+ "TLFREPRESENTANTE_056, TERAPE_056, FORPRE_056, COD_DATOS_NOTIF_056, MIGRADO_056) ("
				+ "SELECT ?, ?, ?, FECPRE_056, NUEVA_056, TIPDOC_056, NUMDOC_056, NOMEMP_056, PAISEMP_056, PRVEMP_056, MUNEMP_056, DMUNEMP_056, DIREMP_056, "
				+ "CPOEMP_056, TLFEMP_056, CNAEEMP_056, ENTIAT_056, TIPAPE_056, NOMCTR_056, PRVCTR_056, MUNCTR_056, LOCCTR_056, DIRCTR_056, CPOCTR_056, TLFCTR_056, FAXCTR_056, EMAILCTR_056, CNAECTR_056, "
				+ "PRVSS_056, NUMSS_056, DIGSS_056, FECINI_056, TRBHOM_056, TRBMUJ_056, TRBTOT_056, CLASCTR_056, DESCOBR_056, SUPERF_056, PLANSEG_056, CANALPLAN_056, PLANPRES_056, PROYTEC_056, "
				+ "DESCMAQ_056, POTEN_056, INDANX_056, APDOANX_056, DESTRAB_056, INDOBRA_056, ?, CODCTR_056, LOTEMNT_056, ASGOSL_056, "
				+ "sysdate, CODENTIAT_056, CNAECTR93_056, CNAEEMP93_056, MODPRE_056, NUMCNT_056, EVALPRES_056, CANALEVAL_056, REGEMP_056, NUMDOCREPRESENTANTE_056,NOMREPRESENTANTE_056,TIPDOCREPRESENTANTE_056, "
				+ "TLFREPRESENTANTE_056, ?, ?, ?, 'N' FROM AB0456S01 WHERE NUMREGISTRO_056 = ? "
				+ ")";

		Integer codDatosNotificacion = null;
		if (apertura.getDatosNotificacion() != null) {
			codDatosNotificacion = apertura.getDatosNotificacion()
					.getCodDatosNotif066();
		}

		apertura.setIdape056(
				Secuencias.ID_APE_056.getNextLong(this.jdbcTemplate));

		this.jdbcTemplate.update(query, apertura.getAnoape056(),
				apertura.getNumape056(), apertura.getIdape056(),
				apertura.getCodobra056(), apertura.getTerape056(),
				Constantes.TIPO_PRESENTACION_TELEMATICO, codDatosNotificacion,
				apertura.getNumReg());
		return apertura;
	}

	/**
	 * Inserts a single row in the Ab04b56s00 table.
	 * 
	 * ab04b56s00 Ab04b56s00 Ab04b56s00
	 * 
	 * @param ab04b56s00
	 *            the ab 04 b 56 s 00
	 * @return the comunicacion apertura
	 */
	public ComunicacionApertura addPresencial(ComunicacionApertura ab04b56s00) {
		String query = "INSERT INTO AB0456S00 (ANOAPE_056, TERAPE_056, NUMAPE_056, IDAPE_056, TIPDOC_056, NUMDOC_056,NOMEMP_056, "
				+ "PAISEMP_056,PRVEMP_056, MUNEMP_056, DMUNEMP_056, DIREMP_056, CPOEMP_056, TLFEMP_056, CNAEEMP_056, CODENTIAT_056, ENTIAT_056, DESEA_REG_056, NUM_REGISTRO_056, FEC_REGISTRO_056, INDOBRA_056, NUEVA_056, FORPRE_056, MIGRADO_056) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";

		ab04b56s00.setIdape056(
				Secuencias.ID_APE_056.getNextLong(this.jdbcTemplate));

		this.jdbcTemplate.update(query, ab04b56s00.getAnoape056(),
				ab04b56s00.getTerape056(), ab04b56s00.getNumape056(),
				ab04b56s00.getIdape056(), ab04b56s00.getTipdoc056(),
				ab04b56s00.getNumdoc056(), ab04b56s00.getNomemp056(),
				ab04b56s00.getPaisemp056(),
				ab04b56s00.getProvinciaEmp().getCodProvincia(),
				ab04b56s00.getMunicipioEmp().getCodMunicipio(),
				ab04b56s00.getDmunemp056(), ab04b56s00.getDiremp056(),
				ab04b56s00.getCpoemp056(), ab04b56s00.getTlfemp056(),
				ab04b56s00.getCnaeemp056(), ab04b56s00.getCodentiat056(),
				ab04b56s00.getEntiat056(), ab04b56s00.getDeseaRegistrar(),
				ab04b56s00.getNumReg(), ab04b56s00.getFecReg(),
				ab04b56s00.getIndobra056(), ab04b56s00.getNueva056(),
				Constantes.TIPO_PRESENTACION_PRESENCIAL, Constantes.VALUE_NO);
		return ab04b56s00;
	}

	/**
	 * Updates a single row in the Ab04b56s00 table.
	 * 
	 * ab04b56s00 Ab04b56s00 Ab04b56s00
	 * 
	 * @param ab04b56s00
	 *            the ab 04 b 56 s 00
	 * @return the comunicacion apertura
	 */
	public ComunicacionApertura update(ComunicacionApertura ab04b56s00) {
		String query = "UPDATE AB0456S00 SET FECPRE_056=?, FECIER_056=?, NUEVA_056=?, TIPDOC_056=?, NUMDOC_056=?, NOMEMP_056=?,PRVEMP_056=?, MUNEMP_056=?, DMUNEMP_056=?, DIREMP_056=?, CPOEMP_056=?, TLFEMP_056=?, CNAEEMP_056=?, ENTIAT_056=?, TIPAPE_056=?, NOMCTR_056=?, PRVCTR_056=?, MUNCTR_056=?, LOCCTR_056=?, DIRCTR_056=?, CPOCTR_056=?, TLFCTR_056=?, FAXCTR_056=?, EMAILCTR_056=?, CNAECTR_056=?, PRVSS_056=?, NUMSS_056=?, DIGSS_056=?, FECINI_056=?, TRBHOM_056=?, TRBMUJ_056=?, TRBTOT_056=?, CLASCTR_056=?, DESCOBR_056=?, SUPERF_056=?, PLANSEG_056=?, CANALPLAN_056=?, PLANPRES_056=?, PROYTEC_056=?, DESCMAQ_056=?, POTEN_056=?, INDANX_056=?, APDOANX_056=?, DESTRAB_056=?, INDOBRA_056=?, CODOBRA_056=?, CODCTR_056=?, LOTEMNT_056=?, VISOSL_056=?, ASGOSL_056=?, TECOSL_056=?, FVISOSL_056=?, VISINS_056=?, ASGINS_056=?, TECINS_056=?, FVISINS_056=?, FECINSP_056=?, FECREQ_056=?, FECSUB_056=?, FINFOSL_056=?, FINFINSP_056=?, FECALT_056=?, USUALT_056=?, FECMOD_056=?, USUMOD_056=?, DOCCORRECTA_056=?, CODENTIAT_056=?, ESTADOCIER_056=?, ESTADO_056=?, CNAECTR93_056=?, CNAEEMP93_056=?, MODPRE_056=?, NUMCNT_056=?, EVALPRES_056=?, CANALEVAL_056=?, REGEMP_056=?, NUMDOCREPRESENTANTE_056=?,NOMREPRESENTANTE_056=?,TIPDOCREPRESENTANTE_056=?, TLFREPRESENTANTE_056=?, FORPRE_056=?, IDAPE_056=?, FOLDER_ID_056=?, COD_DATOS_NOTIF_056=? WHERE TERAPE_056=? AND ANOAPE_056=? AND NUMAPE_056=?";

		Integer codDatosNotificacion = null;
		if (ab04b56s00.getDatosNotificacion() != null) {
			codDatosNotificacion = ab04b56s00.getDatosNotificacion()
					.getCodDatosNotif066();
		}

		this.jdbcTemplate.update(query, ab04b56s00.getFecpre056(),
				ab04b56s00.getFecier056(), ab04b56s00.getNueva056(),
				ab04b56s00.getTipdoc056(), ab04b56s00.getNumdoc056(),
				ab04b56s00.getNomemp056(),
				ab04b56s00.getProvinciaEmp().getCodProvincia(),
				ab04b56s00.getMunicipioEmp().getCodMunicipio(),
				ab04b56s00.getDmunemp056(), ab04b56s00.getDiremp056(),
				ab04b56s00.getCpoemp056(), ab04b56s00.getTlfemp056(),
				ab04b56s00.getCnaeemp056(), ab04b56s00.getEntiat056(),
				ab04b56s00.getTipoApertura().getTipape071(),
				ab04b56s00.getNomctr056(),
				ab04b56s00.getProvinciaCtr().getCodProvincia(),
				ab04b56s00.getMunicipioCtr().getCodMunicipio(),
				ab04b56s00.getLocctr056(), ab04b56s00.getDirctr056(),
				ab04b56s00.getCpoctr056(), ab04b56s00.getTlfctr056(),
				ab04b56s00.getFaxctr056(), ab04b56s00.getEmailctr056(),
				ab04b56s00.getCnaectr056(), ab04b56s00.getPrvss056(),
				ab04b56s00.getNumss056(), ab04b56s00.getDigss056(),
				ab04b56s00.getFecini056(), ab04b56s00.getTrbhom056(),
				ab04b56s00.getTrbmuj056(), ab04b56s00.getTrbtot056(),
				ab04b56s00.getClasctr056(), ab04b56s00.getDescobr056(),
				ab04b56s00.getSuperf056(), ab04b56s00.getPlanseg056(),
				ab04b56s00.getCanalplan056(), ab04b56s00.getPlanpres056(),
				ab04b56s00.getProytec056(), ab04b56s00.getDescmaq056(),
				ab04b56s00.getPoten056(), ab04b56s00.getIndanx056(),
				ab04b56s00.getApdoanx056(), ab04b56s00.getDestrab056(),
				ab04b56s00.getIndobra056(), ab04b56s00.getCodobra056(),
				ab04b56s00.getCodctr056(), ab04b56s00.getLotemnt056(),
				ab04b56s00.getVisosl056(), ab04b56s00.getAsgosl056(),
				ab04b56s00.getTecosl056(), ab04b56s00.getFvisosl056(),
				ab04b56s00.getVisins056(), ab04b56s00.getAsgins056(),
				ab04b56s00.getTecins056(), ab04b56s00.getFvisins056(),
				ab04b56s00.getFecinsp056(), ab04b56s00.getFecreq056(),
				ab04b56s00.getFecsub056(), ab04b56s00.getFinfosl056(),
				ab04b56s00.getFinfinsp056(), ab04b56s00.getFecalt056(),
				ab04b56s00.getUsualt056(), ab04b56s00.getFecmod056(),
				ab04b56s00.getUsumod056(), ab04b56s00.getDoccorrecta056(),
				ab04b56s00.getCodentiat056(), ab04b56s00.getEstadocier056(),
				ab04b56s00.getEstado056(), ab04b56s00.getCnaectr93056(),
				ab04b56s00.getCnaeemp93056(), ab04b56s00.getModpre056(),
				ab04b56s00.getNumcnt056(), ab04b56s00.getEvalpres056(),
				ab04b56s00.getCanaleval056(), ab04b56s00.getRegemp056(),
				ab04b56s00.getNumdocrepresentante056(),
				ab04b56s00.getNombrerepresentante056(),
				ab04b56s00.getTipdocrepresentante056(),
				ab04b56s00.getTlfrepresentante056(), ab04b56s00.getForpre056(),
				ab04b56s00.getIdape056(), ab04b56s00.getFolderId056(),
				codDatosNotificacion, ab04b56s00.getTerape056(),
				ab04b56s00.getAnoape056(), ab04b56s00.getNumape056());
		return ab04b56s00;
	}

	/**
	 * Updates a single row in the Expedientes table.
	 * 
	 * apertura ComunicacionApertura ComunicacionApertura
	 * 
	 * @param apertura
	 *            the apertura
	 * @return the comunicacion apertura
	 */
	public ComunicacionApertura updateFilled(ComunicacionApertura apertura) {
		StringBuilder query = new StringBuilder("UPDATE AB0456S00 SET ");

		List<Object> params = new ArrayList<Object>();
		StringBuilder queryFields = new StringBuilder();

		if (apertura != null) {

			if (apertura.getFolderId056() != null) {
				queryFields.append(", FOLDER_ID_056 = ? ");
				params.add(apertura.getFolderId056());
			}

			if (apertura.getFecpre056() != null) {
				queryFields.append(", FECPRE_056 = ? ");
				params.add(apertura.getFecpre056());
			}

			if (apertura.getFecpre056() != null) {
				queryFields.append(", ESTADO_056 = ? ");
				params.add(apertura.getEstado056());
			}

			if (queryFields.length() > 0) {
				queryFields.deleteCharAt(0);
			}
		}

		query.append(queryFields);
		query.append(" WHERE TERAPE_056=? AND ANOAPE_056=? AND NUMAPE_056=?");

		params.add(apertura.getTerape056());
		params.add(apertura.getAnoape056());
		params.add(apertura.getNumape056());

		this.jdbcTemplate.update(query.toString(), params.toArray());
		return apertura;
	}

	/**
	 * Updates a single row in the Expedientes table.
	 * 
	 * apertura ComunicacionApertura ComunicacionApertura
	 * 
	 * @param apertura
	 *            the apertura
	 * @return the comunicacion apertura
	 */
	public ComunicacionApertura updateCierre(ComunicacionApertura apertura) {
		StringBuilder query = new StringBuilder("UPDATE AB0456S00 SET ");

		List<Object> params = new ArrayList<Object>();
		StringBuilder queryFields = new StringBuilder();

		queryFields.append("FECIER_056 = sysdate, ");

		queryFields.append("ESTADO_056 = 'C' ");

		query.append(queryFields);
		query.append(" WHERE TERAPE_056=? AND ANOAPE_056=? AND NUMAPE_056=?");

		params.add(apertura.getTerape056());
		params.add(apertura.getAnoape056());
		params.add(apertura.getNumape056());

		this.jdbcTemplate.update(query.toString(), params.toArray());
		return apertura;
	}

	/**
	 * Updates a single row in the Expedientes table.
	 * 
	 * apertura ComunicacionApertura ComunicacionApertura
	 * 
	 * @param apertura
	 *            the apertura
	 */
	public void updateCierreTemporal(ComunicacionApertura apertura) {
		StringBuilder query = new StringBuilder("UPDATE AB0456S00 SET ");

		List<Object> params = new ArrayList<Object>();
		StringBuilder queryFields = new StringBuilder();

		queryFields.append("ESTADO_056 = ? ");
		params.add(apertura.getEstado056());

		query.append(queryFields);
		query.append(" WHERE TERAPE_056=? AND ANOAPE_056=? AND NUMAPE_056=?");

		params.add(apertura.getTerape056());
		params.add(apertura.getAnoape056());
		params.add(apertura.getNumape056());

		this.jdbcTemplate.update(query.toString(), params.toArray());

	}

	/**
	 * Updates a single row in the Ab04b56s00 table.
	 * 
	 * ab04b56s00 Ab04b56s00 Ab04b56s00
	 * 
	 * @param ab04b56s00
	 *            the ab 04 b 56 s 00
	 * @return the comunicacion apertura
	 */
	public ComunicacionApertura modificarDatosTabProcAlmac(
			ComunicacionApertura ab04b56s00) {
		String query = "UPDATE AB0456S00 SET DESCMAQ_056=?, POTEN_056=?, SUPERF_056=?, INDANX_056=?, APDOANX_056=?, DESTRAB_056=?, FECMOD_056=sysdate WHERE TERAPE_056=? AND ANOAPE_056=? AND NUMAPE_056=?";
		this.jdbcTemplate.update(query, ab04b56s00.getDescmaq056(),
				ab04b56s00.getPoten056(), ab04b56s00.getSuperf056(),
				ab04b56s00.getIndanx056(), ab04b56s00.getApdoanx056(),
				ab04b56s00.getDestrab056(), ab04b56s00.getTerape056(),
				ab04b56s00.getAnoape056(), ab04b56s00.getNumape056());
		return ab04b56s00;
	}

	/**
	 * Updates a single row in the Ab04b56s00 table.
	 * 
	 * ab04b56s00 Ab04b56s00 Ab04b56s00
	 * 
	 * @param ab04b56s00
	 *            the ab 04 b 56 s 00
	 * @return the comunicacion apertura
	 */
	public ComunicacionApertura modificarDatosTabNotificacion(
			ComunicacionApertura ab04b56s00) {
		String query = "UPDATE AB0456S00 SET COD_DATOS_NOTIF_056=?, FECMOD_056=sysdate, MAIL_CONTACTO_SOLIC_056=?, TELEF_CONTACTO_SOLIC_056=?,NUMDOCREPRESENTANTE_056=?,NOMREPRESENTANTE_056=?,TIPDOCREPRESENTANTE_056=? WHERE TERAPE_056=? AND ANOAPE_056=? AND NUMAPE_056=?";
		this.jdbcTemplate.update(query,
				ab04b56s00.getDatosNotificacion().getCodDatosNotif066(),
				ab04b56s00.getMailContactoSolic056(),
				ab04b56s00.getTelefContactoSolic056(),
				ab04b56s00.getNumdocrepresentante056(),
				ab04b56s00.getNombrerepresentante056(),
				ab04b56s00.getTipdocrepresentante056(),
				ab04b56s00.getTerape056(), ab04b56s00.getAnoape056(),
				ab04b56s00.getNumape056());
		return ab04b56s00;
	}

	/**
	 * Updates a single row in the Ab04b56s00 table.
	 * 
	 * ab04b56s00 Ab04b56s00 Ab04b56s00
	 * 
	 * @param ab04b56s00
	 *            the ab 04 b 56 s 00
	 * @return the comunicacion apertura
	 */
	public ComunicacionApertura modificarDatosTabNotificacionContacto(
			ComunicacionApertura ab04b56s00) {
		String query = "UPDATE AB0456S00  set MAIL_CONTACTO_SOLIC_056=?, TELEF_CONTACTO_SOLIC_056=?,NUMDOCREPRESENTANTE_056=?,NOMREPRESENTANTE_056=?,TIPDOCREPRESENTANTE_056=? WHERE TERAPE_056=? AND ANOAPE_056=? AND NUMAPE_056=?";
		this.jdbcTemplate.update(query, ab04b56s00.getMailContactoSolic056(),
				ab04b56s00.getTelefContactoSolic056(),
				ab04b56s00.getNumdocrepresentante056(),
				ab04b56s00.getNombrerepresentante056(),
				ab04b56s00.getTipdocrepresentante056(),
				ab04b56s00.getTerape056(), ab04b56s00.getAnoape056(),
				ab04b56s00.getNumape056());
		return ab04b56s00;
	}

	/**
	 * Updates a single row in the Ab04b56s00 table.
	 * 
	 * ab04b56s00 Ab04b56s00 Ab04b56s00
	 * 
	 * @param ab04b56s00
	 *            the ab 04 b 56 s 00
	 * @return the comunicacion apertura
	 */
	public ComunicacionApertura modificarDatosTabDatosObra(
			ComunicacionApertura ab04b56s00) {
		String query = "UPDATE AB0456S00 SET REGEMP_056=?, PLANSEG_056=?, CANALPLAN_056=?, EVALPRES_056=?,CANALEVAL_056=?,NUMCNT_056=?, FECMOD_056=sysdate  WHERE TERAPE_056=? AND ANOAPE_056=? AND NUMAPE_056=?";
		this.jdbcTemplate.update(query, ab04b56s00.getRegemp056Completo(),
				ab04b56s00.getPlanseg056(), ab04b56s00.getCanalplan056(),
				ab04b56s00.getEvalpres056(), ab04b56s00.getCanaleval056(),
				ab04b56s00.getNumcnt056(), ab04b56s00.getTerape056(),
				ab04b56s00.getAnoape056(), ab04b56s00.getNumape056());
		return ab04b56s00;
	}

	/**
	 * Updates a single row in the Ab04b56s00 table.
	 * 
	 * ab04b56s00 Ab04b56s00 Ab04b56s00
	 * 
	 * @param ab04b56s00
	 *            the ab 04 b 56 s 00
	 * @return the comunicacion apertura
	 */
	public ComunicacionApertura modificarDatosRegistro(
			ComunicacionApertura ab04b56s00) {
		String query = "UPDATE AB0456S00 SET DESEA_REG_056=?, NUM_REGISTRO_056=?, FEC_REGISTRO_056=?  WHERE TERAPE_056=? AND ANOAPE_056=? AND NUMAPE_056=?";
		this.jdbcTemplate.update(query, ab04b56s00.getDeseaRegistrar(),
				ab04b56s00.getNumReg(), ab04b56s00.getFecReg(),
				ab04b56s00.getTerape056(), ab04b56s00.getAnoape056(),
				ab04b56s00.getNumape056());
		return ab04b56s00;
	}

	/**
	 * Updates a single row in the Ab04b56s00 table.
	 * 
	 * ab04b56s00 Ab04b56s00 Ab04b56s00
	 * 
	 * @param ab04b56s00
	 *            the ab 04 b 56 s 00
	 * @return the comunicacion apertura
	 */
	public ComunicacionApertura modificarDatosTabDatosCentro(
			ComunicacionApertura ab04b56s00) {
		String query = "UPDATE AB0456S00 SET TIPAPE_056=?, DESCOBR_056=?, NOMCTR_056=?, PRVCTR_056=?, MUNCTR_056=?,LOCCTR_056=?,DIRCTR_056=?,"
				+ "CPOCTR_056=?, FAXCTR_056=?, EMAILCTR_056=?, TLFCTR_056=?,FECINI_056=?, PRVSS_056=?, NUMSS_056=?, DIGSS_056=?,TRBHOM_056=?, TRBMUJ_056=?, TRBTOT_056=?,  "
				+ " CLASCTR_056=?, CNAECTR_056=?, MODPRE_056=?, FECMOD_056=sysdate, VISOSL_056=?, ASGOSL_056=?, TECOSL_056=?, FVISOSL_056=?, RAZON_SOCIAL_ANT_056 = ?, DIRECC_ANT_056 = ? WHERE TERAPE_056=? AND ANOAPE_056=? AND NUMAPE_056=?";
		this.jdbcTemplate.update(query,

				(ab04b56s00.getTipoApertura() != null
						? ab04b56s00.getTipoApertura().getTipape071() : ""),
				ab04b56s00.getNomctr056(), ab04b56s00.getNomctr056(),
				(ab04b56s00.getProvinciaCtr() != null
						? ab04b56s00.getProvinciaCtr().getCodProvincia() : ""),
				(ab04b56s00.getMunicipioCtr() != null
						? ab04b56s00.getMunicipioCtr().getCodMunicipio() : ""),
				ab04b56s00.getLocctr056(), ab04b56s00.getDirctr056(),
				ab04b56s00.getCpoctr056(), ab04b56s00.getFaxctr056(),
				ab04b56s00.getEmailctr056(), ab04b56s00.getTlfctr056(),
				ab04b56s00.getFecini056(), ab04b56s00.getPrvss056(),
				ab04b56s00.getNumss056(), ab04b56s00.getDigss056(),
				ab04b56s00.getTrbhom056(), ab04b56s00.getTrbmuj056(),
				ab04b56s00.getTrbtot056(), ab04b56s00.getClasctr056(),
				ab04b56s00.getCnaectr056(), ab04b56s00.getModpre056(),
				ab04b56s00.getVisosl056(), ab04b56s00.getAsgosl056(),
				ab04b56s00.getTecosl056(), ab04b56s00.getFvisosl056(),
				ab04b56s00.getRazonSocialAnt056(),
				ab04b56s00.getDireccionAnt056(), ab04b56s00.getTerape056(),
				ab04b56s00.getAnoape056(), ab04b56s00.getNumape056());
		return ab04b56s00;
	}

	/**
	 * Updates a single row in the Ab04b56s00 table.
	 * 
	 * ab04b56s00 Ab04b56s00 Ab04b56s00
	 * 
	 * @param ab04b56s00
	 *            the ab 04 b 56 s 00
	 * @return the comunicacion apertura
	 */
	public ComunicacionApertura modificarDatosTabDatosCentroAsignado(
			ComunicacionApertura ab04b56s00) {
		String query = "UPDATE AB0456S00 SET  DESCOBR_056=?, NOMCTR_056=?, PRVCTR_056=?, MUNCTR_056=?,DIRCTR_056=?,"
				+ "CPOCTR_056=?, FAXCTR_056=?, EMAILCTR_056=?, TLFCTR_056=?, CNAECTR_056=?,  FECMOD_056=sysdate  WHERE TERAPE_056=? AND ANOAPE_056=? AND NUMAPE_056=?";
		this.jdbcTemplate.update(query, ab04b56s00.getNomctr056(),
				ab04b56s00.getNomctr056(),
				(ab04b56s00.getProvinciaCtr() != null
						? ab04b56s00.getProvinciaCtr().getCodProvincia() : ""),
				(ab04b56s00.getMunicipioCtr() != null
						? ab04b56s00.getMunicipioCtr().getCodMunicipio() : ""),
				ab04b56s00.getDirctr056(), ab04b56s00.getCpoctr056(),
				ab04b56s00.getFaxctr056(), ab04b56s00.getEmailctr056(),
				ab04b56s00.getTlfctr056(), ab04b56s00.getCnaectr056(),
				ab04b56s00.getTerape056(), ab04b56s00.getAnoape056(),
				ab04b56s00.getNumape056());
		return ab04b56s00;
	}

	/**
	 * Updates a single row in the Ab04b56s00 table.
	 * 
	 * ab04b56s00 Ab04b56s00 Ab04b56s00
	 * 
	 * @param ab04b56s00
	 *            the ab 04 b 56 s 00
	 * @return the comunicacion apertura
	 */
	public ComunicacionApertura modificarDatosVisitaOsalan(
			ComunicacionApertura ab04b56s00) {
		String query = "UPDATE AB0456S00 SET VISOSL_056=?, ASGOSL_056=?, TECOSL_056=?, FVISOSL_056=? "
				+ " WHERE TERAPE_056=? AND ANOAPE_056=? AND NUMAPE_056=?";
		this.jdbcTemplate.update(query, ab04b56s00.getVisosl056(),
				ab04b56s00.getAsgosl056(), ab04b56s00.getTecosl056(),
				ab04b56s00.getFvisosl056(), ab04b56s00.getTerape056(),
				ab04b56s00.getAnoape056(), ab04b56s00.getNumape056());
		return ab04b56s00;
	}

	/**
	 * Updates a single row in the Ab04b56s00 table.
	 * 
	 * ab04b56s00 Ab04b56s00 Ab04b56s00
	 * 
	 * @param ab04b56s00
	 *            the ab 04 b 56 s 00
	 * @return the comunicacion apertura
	 */
	public ComunicacionApertura modificarDatosTabDatosEmpresa(
			ComunicacionApertura ab04b56s00) {
		String query = "UPDATE AB0456S00 SET INDOBRA_056=?, CODCTR_056=?, NUEVA_056=?, TIPDOC_056=?, NUMDOC_056=?, NOMEMP_056=?, PAISEMP_056=?, "
				+ " PRVEMP_056=?, MUNEMP_056=?, DMUNEMP_056=?, DIREMP_056=?, CPOEMP_056=?, TLFEMP_056=?, CNAEEMP_056=?, CODENTIAT_056=?, ENTIAT_056=? "
				+ ", FECMOD_056=sysdate WHERE TERAPE_056=? AND ANOAPE_056=? AND NUMAPE_056=?";
		this.jdbcTemplate.update(query, ab04b56s00.getIndobra056(),
				ab04b56s00.getCodctr056(), ab04b56s00.getNueva056(),
				ab04b56s00.getTipdoc056(), ab04b56s00.getNumdoc056(),
				ab04b56s00.getNomemp056(), ab04b56s00.getPaisemp056(),
				ab04b56s00.getProvinciaEmp() != null
						? ab04b56s00.getProvinciaEmp().getCodProvincia() : "",
				ab04b56s00.getMunicipioEmp() != null
						? ab04b56s00.getMunicipioEmp().getCodMunicipio() : "",
				ab04b56s00.getDmunemp056(), ab04b56s00.getDiremp056(),
				ab04b56s00.getCpoemp056(), ab04b56s00.getTlfemp056(),
				ab04b56s00.getCnaeemp056(), ab04b56s00.getCodentiat056(),
				ab04b56s00.getEntiat056(), ab04b56s00.getTerape056(),
				ab04b56s00.getAnoape056(), ab04b56s00.getNumape056());
		return ab04b56s00;
	}

	/**
	 * Updates a single row in the Ab04b56s00 table.
	 * 
	 * apertura ComunicacionApertura ComunicacionApertura
	 * 
	 * @param apertura
	 *            the apertura
	 * @return the comunicacion apertura
	 */
	public ComunicacionApertura modificarDatosTabEstadoDoc(
			ComunicacionApertura apertura) {
		String query = "UPDATE AB0456S00 SET DOCCORRECTA_056=? WHERE TERAPE_056=? AND ANOAPE_056=? AND NUMAPE_056=?";
		this.jdbcTemplate.update(query, new Object[] {
				(apertura.getDoccorrecta056() != null)
						? apertura.getDoccorrecta056() : Constantes.VALUE_NO,
				apertura.getTerape056(), apertura.getAnoape056(),
				apertura.getNumape056() });
		return apertura;
	}

	/**
	 * Finds a single row in the Ab04b56s00 table.
	 * 
	 * ab04b56s00 Ab04b56s00 Ab04b56s00
	 * 
	 * @param ab04b56s00
	 *            the ab 04 b 56 s 00
	 * @return the comunicacion apertura
	 */
	@Transactional(readOnly = true)
	public ComunicacionApertura find(ComunicacionApertura ab04b56s00) {
		StringBuilder query = new StringBuilder(
				ComunicacionAperturaDaoImpl.QUERY_SELECT);
		query.append(" FROM AB0456S00 t1 ");
		query.append(
				" WHERE t1.TERAPE_056=? AND t1.ANOAPE_056=? AND t1.NUMAPE_056=? ");

		List<ComunicacionApertura> ab04b56s00List = this.jdbcTemplate.query(
				query.toString(), this.rwMap, ab04b56s00.getTerape056(),
				ab04b56s00.getAnoape056(), ab04b56s00.getNumape056());
		return (ComunicacionApertura) DataAccessUtils
				.uniqueResult(ab04b56s00List);
	}

	/**
	 * Finds a single row in the Ab04b56s00 table.
	 * 
	 * ab04b56s00 Ab04b56s00 Ab04b56s00
	 * 
	 * @param ab04b56s00
	 *            the ab 04 b 56 s 00
	 * @return the comunicacion apertura
	 */
	@Transactional(readOnly = true)
	public ComunicacionApertura find3(ComunicacionApertura ab04b56s00) {
		StringBuilder query = new StringBuilder(
				ComunicacionAperturaDaoImpl.QUERY_SELECT3);
		// query.append(" FROM AB0456S00 t1 ");
		query.append(
				" FROM AB0456S00 t1  left outer join AB0482S00 t2 on t1.CODOBRA_056=t2.CODOBRA_082 ");
		query.append(
				" WHERE t1.TERAPE_056=? AND t1.ANOAPE_056=? AND t1.NUMAPE_056=? ");

		List<ComunicacionApertura> ab04b56s00List = this.jdbcTemplate.query(
				query.toString(), this.rwMap3, ab04b56s00.getTerape056(),
				ab04b56s00.getAnoape056(), ab04b56s00.getNumape056());
		return (ComunicacionApertura) DataAccessUtils
				.uniqueResult(ab04b56s00List);
	}

	/**
	 * Finds a single row in the Ab04b56s00 table.
	 * 
	 * folderId String Ab04b56s00
	 * 
	 * @param folderId
	 *            the folder id
	 * @return the comunicacion apertura
	 */
	@Transactional(readOnly = true)
	public ComunicacionApertura findByFolderId(String folderId) {
		StringBuilder query = new StringBuilder(
				ComunicacionAperturaDaoImpl.QUERY_SELECT);
		query.append(" FROM AB0456S00 t1 inner join  AB0477S00 t2 ");
		query.append(
				" ON t1.ANOAPE_056 = t2.ANOEXP_077 AND t1.TERAPE_056 = t2.TEREXP_077 AND t1.NUMAPE_056 = t2.NUMEXP_077 ");
		query.append(" WHERE t2.FOLDERID_077=? ");

		List<ComunicacionApertura> ab04b56s00List = this.jdbcTemplate
				.query(query.toString(), this.rwMap, folderId);
		return (ComunicacionApertura) DataAccessUtils
				.uniqueResult(ab04b56s00List);
	}

	/**
	 * Finds a single row in the Ab04b56s00 table.
	 * 
	 * folderId String Ab04b56s00
	 * 
	 * @param folderId
	 *            the folder id
	 * @return the comunicacion apertura
	 */
	@Transactional(readOnly = true)
	public ComunicacionApertura findByFolderId2(String folderId) {
		StringBuilder query = new StringBuilder(
				ComunicacionAperturaDaoImpl.QUERY_SELECT_2);
		query.append(" FROM AB0456S00 t1 inner join  AB0477S00 t2 ");
		query.append(
				" ON t1.ANOAPE_056 = t2.ANOEXP_077 AND t1.TERAPE_056 = t2.TEREXP_077 AND t1.NUMAPE_056 = t2.NUMEXP_077 ");
		query.append(" WHERE t2.FOLDERID_077=? ");

		List<ComunicacionApertura> ab04b56s00List = this.jdbcTemplate
				.query(query.toString(), this.rwMapPK, folderId);
		return (ComunicacionApertura) DataAccessUtils
				.uniqueResult(ab04b56s00List);
	}

	/**
	 * Finds a single row in the Ab04b56s00 table.
	 * 
	 * comunicacionApertura ComunicacionApertura Ab04b56s00
	 * 
	 * @param comunicacionApertura
	 *            the comunicacion apertura
	 * @return the comunicacion apertura
	 */
	@Transactional(readOnly = true)
	public ComunicacionApertura findDatosRegistro(
			ComunicacionApertura comunicacionApertura) {
		StringBuilder query = new StringBuilder(
				ComunicacionAperturaDaoImpl.QUERY_SELECT_DATOS_REGISTRO);
		query.append(" FROM AB0456S00 t1 ");
		query.append(
				" WHERE t1.ANOAPE_056 = ? AND t1.TERAPE_056 = ? AND t1.NUMAPE_056 = ? ");

		List<ComunicacionApertura> ab04b56s00List = this.jdbcTemplate.query(
				query.toString(), this.rwMapDatosRegistro,
				comunicacionApertura.getAnoape056(),
				comunicacionApertura.getTerape056(),
				comunicacionApertura.getNumape056());
		return (ComunicacionApertura) DataAccessUtils
				.uniqueResult(ab04b56s00List);
	}

	/**
	 * Removes a single row in the Ab04b56s00 table.
	 * 
	 * ab04b56s00 Ab04b56s00
	 * 
	 * @param ab04b56s00
	 *            the ab 04 b 56 s 00
	 */
	public void remove(ComunicacionApertura ab04b56s00) {
		String query = "DELETE FROM AB0456S00 WHERE TERAPE_056=? AND ANOAPE_056=? AND NUMAPE_056=? ";
		this.jdbcTemplate.update(query, ab04b56s00.getTerape056(),
				ab04b56s00.getAnoape056(), ab04b56s00.getNumape056());
	}

	/**
	 * Updates a single row in the Ab04b56s00 table.
	 * 
	 * ab04b56s00 Ab04b56s00 Ab04b56s00
	 * 
	 * @param ab04b56s00
	 *            the ab 04 b 56 s 00
	 * @return the comunicacion apertura
	 */
	public ComunicacionApertura updateCodObra(ComunicacionApertura ab04b56s00) {
		String query = "UPDATE AB0456S00 SET CODOBRA_056=? WHERE TERAPE_056=? AND ANOAPE_056=? AND NUMAPE_056=?";
		this.jdbcTemplate.update(query, ab04b56s00.getCodobra056(),
				ab04b56s00.getTerape056(), ab04b56s00.getAnoape056(),
				ab04b56s00.getNumape056());
		return ab04b56s00;
	}

	/**
	 * Finds a list of rows in the Ab04b56s00 table.
	 * 
	 * ab04b56s00 Ab04b56s00 jqGridRequestDto JQGridRequestDto List<Ab04b56s00>
	 * 
	 * @param ab04b56s00
	 *            the ab 04 b 56 s 00
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @return the list
	 */
	@Transactional(readOnly = true)
	public List<ComunicacionApertura> findAll(ComunicacionApertura ab04b56s00,
			JQGridRequestDto jqGridRequestDto) {
		StringBuilder query = new StringBuilder(
				ComunicacionAperturaDaoImpl.QUERY_SELECT);
		query.append(" FROM AB0456S00 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(ab04b56s00);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		return (List<ComunicacionApertura>) this.jdbcTemplate
				.query(query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Finds rows in the Ab04b56s00 table using like.
	 * 
	 * ab04b56s00 Ab04b56s00 jqGridRequestDto JQGridRequestDto startsWith
	 * Boolean List<Ab04b56s00>
	 * 
	 * @param ab04b56s00
	 *            the ab 04 b 56 s 00
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @param startsWith
	 *            the starts with
	 * @return the list
	 */
	@Transactional(readOnly = true)
	public List<ComunicacionApertura> findAllLike(
			ComunicacionApertura ab04b56s00, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				ComunicacionAperturaDaoImpl.QUERY_SELECT);
		query.append(" FROM AB0456S00 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(ab04b56s00, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		return (List<ComunicacionApertura>) this.jdbcTemplate
				.query(query.toString(), this.rwMap, params.toArray());
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Counts rows in the Ab04b56s00 table.
	 * 
	 * ab04b56s00 Ab04b56s00 Long
	 * 
	 * @param ab04b56s00
	 *            the ab 04 b 56 s 00
	 * @return the long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(ComunicacionApertura ab04b56s00) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM AB0456S00 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(ab04b56s00);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Counts rows in the Ab04b56s00 table using like.
	 * 
	 * ab04b56s00 Ab04b56s00 startsWith Boolean Long
	 * 
	 * @param ab04b56s00
	 *            the ab 04 b 56 s 00
	 * @param startsWith
	 *            the starts with
	 * @return the long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(ComunicacionApertura ab04b56s00,
			Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM AB0456S00 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(ab04b56s00, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Reorder the data list of Ab04b56s00 selected for rup_table.
	 * 
	 * ab04b56s00 Ab04b56s00 jqGridRequestDto JQGridRequestDto startsWith
	 * Boolean List<TableRowDto<Ab04b56s00>>
	 * 
	 * @param ab04b56s00
	 *            the ab 04 b 56 s 00
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @param startsWith
	 *            the starts with
	 * @return the list
	 */
	@Override()
	public List<TableRowDto<ComunicacionApertura>> reorderSelection(
			ComunicacionApertura ab04b56s00, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.ANOAPE_056 ANOAPE, t1.NUMAPE_056 NUMAPE,t1.TERAPE_056 TERAPE,  "
						+ "t1.FECPRE_056 FECPRE056, t1.FECIER_056 FECIER056, t1.NUEVA_056 NUEVA056, t1.TIPDOC_056 TIPDOC056, "
						+ "t1.NUMDOC_056 NUMDOC056, t1.NOMEMP_056 NOMEMP056, t1.PRVEMP_056 PRVEMP056, t1.MUNEMP_056 MUNEMP056, t1.DMUNEMP_056 DMUNEMP056, "
						+ "t1.DIREMP_056 DIREMP056, t1.CPOEMP_056 CPOEMP056, t1.TLFEMP_056 TLFEMP056, t1.CNAEEMP_056 CNAEEMP056, t1.ENTIAT_056 ENTIAT056, "
						+ "t1.TIPAPE_056 TIPAPE056, t2.DESAPE_ES_071 TIPAPEES, t2.DESAPE_EU_071 TIPAPEEUS, t1.NOMCTR_056 NOMCTR056, t1.PRVCTR_056 PRVCTR056, t1.MUNCTR_056 MUNCTR056, t1.LOCCTR_056 LOCCTR056, "
						+ "t1.DIRCTR_056 DIRCTR056, t1.CPOCTR_056 CPOCTR056, t1.TLFCTR_056 TLFCTR056, t1.FAXCTR_056 FAXCTR056, t1.EMAILCTR_056 EMAILCTR056, "
						+ "t1.CNAECTR_056 CNAECTR056, t1.PRVSS_056 PRVSS056, t1.NUMSS_056 NUMSS056, t1.DIGSS_056 DIGSS056, t1.FECINI_056 FECINI056, t1.TRBHOM_056 "
						+ "TRBHOM056, t1.TRBMUJ_056 TRBMUJ056, t1.TRBTOT_056 TRBTOT056, t1.CLASCTR_056 CLASCTR056, t1.DESCOBR_056 DESCOBR056, t1.SUPERF_056 SUPERF056, "
						+ "t1.PLANSEG_056 PLANSEG056, t1.CANALPLAN_056 CANALPLAN056, t1.PLANPRES_056 PLANPRES056, t1.PROYTEC_056 PROYTEC056, t1.DESCMAQ_056 DESCMAQ056, "
						+ "t1.POTEN_056 POTEN056, t1.INDANX_056 INDANX056, t1.APDOANX_056 APDOANX056, t1.DESTRAB_056 DESTRAB056, t1.INDOBRA_056 INDOBRA056, "
						+ "t1.CODOBRA_056 CODOBRA056, t1.CODCTR_056 CODCTR056, t1.LOTEMNT_056 LOTEMNT056, t1.VISOSL_056 VISOSL056, t1.ASGOSL_056 ASGOSL056,"
						+ " t1.TECOSL_056 TECOSL056, t1.FVISOSL_056 FVISOSL056, t1.VISINS_056 VISINS056, t1.ASGINS_056 ASGINS056, t1.TECINS_056 TECINS056, "
						+ "t1.FVISINS_056 FVISINS056, t1.FECINSP_056 FECINSP056, t1.FECREQ_056 FECREQ056, t1.FECSUB_056 FECSUB056, t1.FINFOSL_056 FINFOSL056, "
						+ "t1.FINFINSP_056 FINFINSP056, t1.FECALT_056 FECALT056, t1.USUALT_056 USUALT056, t1.FECMOD_056 FECMOD056, t1.USUMOD_056 USUMOD056, "
						+ "t1.DOCCORRECTA_056 DOCCORRECTA056, t1.CODENTIAT_056 CODENTIAT056, t1.ESTADOCIER_056 ESTADOCIER056, t1.ESTADO_056 ESTADO056, "
						+ "t1.CNAECTR93_056 CNAECTR93056, t1.CNAEEMP93_056 CNAEEMP93056, t1.MODPRE_056 MODPRE056, t1.NUMCNT_056 NUMCNT056, t1.IDAPE_056 IDAPE056, "
						+ "t1.EVALPRES_056 EVALPRES056, t1.CANALEVAL_056 CANALEVAL056, t1.REGEMP_056 REGEMP056, t1.NUMDOCREPRESENTANTE_056 NUMDOCREPRESENTANTE056, t1.NOMREPRESENTANTE_056 NOMREPRESENTANTE056,TIPDOCREPRESENTANTE_056 TIPDOCREPRESENTANTE, "
						+ "t1.TLFREPRESENTANTE_056 TLFREPRESENTANTE056, t1.FORPRE_056 FORPRE056, t1.FOLDER_ID_056 FOLDERID056, t1.PAISEMP_056 PAISEMP056, "
						+ "t1.COD_DATOS_NOTIF_056 CODDATOSNOTIF056, t1.MIGRADO_056 MIGRADO056 ");
		// FROM
		query.append("FROM AB0456S00 t1, AB0471S00 	t2 ");
		// FILTRADO
		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(ab04b56s00, startsWith);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.TIPAPE_056=t2.TIPAPE_071(+)");
		where.append(mapaWhere.get("query"));
		query.append(where);

		// Parámetros de filtrado
		@SuppressWarnings(value = "unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhere.get("params");

		// SQL para la reordenación
		StringBuilder sbReorderSelectionSQL = JQGridManager.getReorderQuery(
				query, jqGridRequestDto, ComunicacionApertura.class,
				filterParamList, "ANOAPE", "NUMAPE", "TERAPE");

		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(),
				new RowNumResultSetExtractor<ComunicacionApertura>(
						this.rwMapReorder, jqGridRequestDto),
				filterParamList.toArray());
	}

	/**
	 * Search method for rup_table.
	 * 
	 * filterParams Ab04b56s00 searchParams Ab04b56s00 jqGridRequestDto
	 * JQGridRequestDto startsWith Boolean List<TableRowDto<Ab04b56s00>>
	 * 
	 * @param filterParams
	 *            the filter params
	 * @param searchParams
	 *            the search params
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @param startsWith
	 *            the starts with
	 * @return the list
	 */
	@Override()
	public List<TableRowDto<ComunicacionApertura>> search(
			ComunicacionApertura filterParams,
			ComunicacionApertura searchParams,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		// SELECT
		StringBuilder query = new StringBuilder(
				ComunicacionAperturaDaoImpl.QUERY_SELECT);
		// FROM
		query.append("FROM AB0456S00 t1 ");
		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// FILTRADO
		Map<String, ?> mapaWhereFilter = this.getWhereLikeMap(filterParams,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhereFilter.get("query"));
		query.append(where);
		// Filter params
		@SuppressWarnings(value = "unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhereFilter
				.get("params");

		// BUSQUEDA
		Map<String, Object> mapaWhereSearch = this.getWhereLikeMap(searchParams,
				startsWith);
		String searchSQL = ((StringBuilder) mapaWhereSearch.get("query"))
				.toString();
		// Search params
		@SuppressWarnings(value = "unchecked")
		List<Object> searchParamList = (List<Object>) mapaWhereSearch
				.get("params");

		// SQL
		StringBuilder sbReorderSelectionSQL = JQGridManager.getSearchQuery(
				query, jqGridRequestDto, ComunicacionApertura.class,
				filterParamList, searchSQL, searchParamList, from_alias,
				"ANOAPE_056,NUMAPE_056,FECPRE_056,FECIER_056,NUEVA_056,TIPDOC_056,NUMDOC_056,NOMEMP_056,PRVEMP_056,MUNEMP_056,DMUNEMP_056,DIREMP_056,CPOEMP_056,TLFEMP_056,CNAEEMP_056,ENTIAT_056,TIPAPE_056,NOMCTR_056,PRVCTR_056,MUNCTR_056,LOCCTR_056,DIRCTR_056,CPOCTR_056,TLFCTR_056,FAXCTR_056,EMAILCTR_056,CNAECTR_056,PRVSS_056,NUMSS_056,DIGSS_056,FECINI_056,TRBHOM_056,TRBMUJ_056,TRBTOT_056,CLASCTR_056,DESCOBR_056,SUPERF_056,PLANSEG_056,CANALPLAN_056,PLANPRES_056,PROYTEC_056,DESCMAQ_056,POTEN_056,INDANX_056,APDOANX_056,DESTRAB_056,INDOBRA_056,CODOBRA_056,CODCTR_056,LOTEMNT_056,VISOSL_056,ASGOSL_056,TECOSL_056,FVISOSL_056,VISINS_056,ASGINS_056,TECINS_056,FVISINS_056,FECINSP_056,FECREQ_056,FECSUB_056,FINFOSL_056,FINFINSP_056,FECALT_056,USUALT_056,FECMOD_056,USUMOD_056,DOCCORRECTA_056,CODENTIAT_056,ESTADOCIER_056,ESTADO_056,CNAECTR93_056,CNAEEMP93_056,MODPRE_056,NUMCNT_056,IDAPE_056,EVALPRES_056,CANALEVAL_056,REGEMP_056,NUMDOCREPRESENTANTE_056,NOMREPRESENTANTE_056,TIPDOCREPRESENTANTE_056,TLFREPRESENTANTE_056,TERAPE_056,FORPRE_056");

		return this.jdbcTemplate
				.query(sbReorderSelectionSQL.toString(),
						new RowNumResultSetExtractor<ComunicacionApertura>(
								this.rwMapPK, jqGridRequestDto),
						filterParamList.toArray());
	}

	/**
	 * Finds rows in the Ab04b56s00 table using like.
	 * 
	 * ab04b56s00 Ab04b56s00 List<Ab04b56s00>
	 * 
	 * @param ab04b56s00
	 *            the ab 04 b 56 s 00
	 * @return the list
	 */
	@Transactional(readOnly = true)
	public List<ComunicacionApertura> findEmpresaObra(
			ComunicacionApertura ab04b56s00) {
		StringBuilder query = new StringBuilder(
				ComunicacionAperturaDaoImpl.QUERY_SELECT);
		query.append(" FROM AB0456S00 t1 ");
		query.append("WHERE  UPPER(INDOBRA_056) = UPPER('S') AND ");
		query.append(" UPPER(TIPDOC_056) = UPPER('" + ab04b56s00.getTipdoc056()
				+ "') AND ");
		query.append(" UPPER(NUMDOC_056) = UPPER('" + ab04b56s00.getNumdoc056()
				+ "') ");
		query.append("	AND FECPRE_056  = (SELECT MAX(FECPRE_056)")
				.append(" FROM AB0456S00 t1 ");
		query.append("  WHERE ");
		query.append(" UPPER(INDOBRA_056) = UPPER('"
				+ ab04b56s00.getIndobra056() + "') AND ");
		query.append(" UPPER(TIPDOC_056) = UPPER('" + ab04b56s00.getTipdoc056()
				+ "') AND ");
		query.append(" UPPER(NUMDOC_056) = UPPER('" + ab04b56s00.getNumdoc056()
				+ "'))");

		return (List<ComunicacionApertura>) this.getJdbcTemplate()
				.query(query.toString(), this.rwMap);
	}

	/**
	 * Remove multiple method for rup_table.
	 * 
	 * filterab04b56s00 Ab04b56s00 jqGridRequestDto JQGridRequestDto startsWith
	 * Boolean
	 * 
	 * @param filterab04b56s00
	 *            the filterab 04 b 56 s 00
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @param startsWith
	 *            the starts with
	 */
	@Override()
	public void removeMultiple(ComunicacionApertura filterab04b56s00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		// SELECT
		/** TODO: select por clave */
		StringBuilder query = new StringBuilder(
				ComunicacionAperturaDaoImpl.QUERY_SELECT);
		// FROM
		query.append("FROM AB0456S00 t1 ");

		// WHERE
		Map<String, Object> mapaWhere = this.getWhereLikeMap(filterab04b56s00,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		@SuppressWarnings(value = "unchecked")
		List<Object> params = (List<Object>) mapaWhere.get("params");

		StringBuilder sbRemoveMultipleSQL = JQGridManager
				.getRemoveMultipleQuery(jqGridRequestDto,
						ComunicacionApertura.class, query, params,
						"ANOAPE_056,NUMAPE_056,FECPRE_056,FECIER_056,NUEVA_056,TIPDOC_056,NUMDOC_056,NOMEMP_056,PRVEMP_056,MUNEMP_056,DMUNEMP_056,DIREMP_056,CPOEMP_056,TLFEMP_056,CNAEEMP_056,ENTIAT_056,TIPAPE_056,NOMCTR_056,PRVCTR_056,MUNCTR_056,LOCCTR_056,DIRCTR_056,CPOCTR_056,TLFCTR_056,FAXCTR_056,EMAILCTR_056,CNAECTR_056,PRVSS_056,NUMSS_056,DIGSS_056,FECINI_056,TRBHOM_056,TRBMUJ_056,TRBTOT_056,CLASCTR_056,DESCOBR_056,SUPERF_056,PLANSEG_056,CANALPLAN_056,PLANPRES_056,PROYTEC_056,DESCMAQ_056,POTEN_056,INDANX_056,APDOANX_056,DESTRAB_056,INDOBRA_056,CODOBRA_056,CODCTR_056,LOTEMNT_056,VISOSL_056,ASGOSL_056,TECOSL_056,FVISOSL_056,VISINS_056,ASGINS_056,TECINS_056,FVISINS_056,FECINSP_056,FECREQ_056,FECSUB_056,FINFOSL_056,FINFINSP_056,FECALT_056,USUALT_056,FECMOD_056,USUMOD_056,DOCCORRECTA_056,CODENTIAT_056,ESTADOCIER_056,ESTADO_056,CNAECTR93_056,CNAEEMP93_056,MODPRE_056,NUMCNT_056,IDAPE_056,EVALPRES_056,CANALEVAL_056,REGEMP_056,NUMDOCREPRESENTANTE_056,NOMREPRESENTANTE_056,TIPDOCREPRESENTANTE_056,TLFREPRESENTANTE_056,TERAPE_056,FORPRE_056");
		this.jdbcTemplate.update(sbRemoveMultipleSQL.toString(),
				params.toArray());
	}

	/**
	 * Updates a single row in the Ab04b56s00 table.
	 * 
	 * ab04b56s00 Ab04b56s00 updateFechaRecInspecc updateFechaRecInspecc
	 * Ab04b56s00
	 * 
	 * @param ab04b56s00
	 *            the ab 04 b 56 s 00
	 * @param updateFechaRecInspecc
	 *            the update fecha rec inspecc
	 * @return the comunicacion apertura
	 */
	public ComunicacionApertura updateFecInspeccion(
			ComunicacionApertura ab04b56s00, boolean updateFechaRecInspecc) {
		String query = "UPDATE AB0456S00 SET  FECINSP_056=? WHERE TERAPE_056=? AND ANOAPE_056=? AND NUMAPE_056=?";

		Date fecha = ab04b56s00.getFecinsp056();

		if (updateFechaRecInspecc) {
			query = "UPDATE AB0456S00 SET  FINFINSP_056=? WHERE TERAPE_056=? AND ANOAPE_056=? AND NUMAPE_056=?";
			fecha = ab04b56s00.getFinfinsp056();
		}

		this.jdbcTemplate.update(query, fecha, ab04b56s00.getTerape056(),
				ab04b56s00.getAnoape056(), ab04b56s00.getNumape056());

		return ab04b56s00;
	}

	/*
	 * MÉTODOS PRIVADOS
	 */

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Ab04b56s00 entity.
	 * 
	 * ab04b56s00 Ab04b56s00 Bean with the criteria values to filter by. Map
	 * created with two keys key query stores the sql query syntax key params
	 * stores the parameter values to be used in the condition sentence.
	 * 
	 * @param ab04b56s00
	 *            the ab 04 b 56 s 00
	 * @return the where map
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(ComunicacionApertura ab04b56s00) {

		StringBuilder where = new StringBuilder(
				ComunicacionAperturaDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (ab04b56s00 != null && ab04b56s00.getAnoape056() != null) {
			where.append(" AND t1.ANOAPE_056 = ?");
			params.add(ab04b56s00.getAnoape056());
		}
		if (ab04b56s00 != null && ab04b56s00.getNumape056() != null) {
			where.append(" AND t1.NUMAPE_056 = ?");
			params.add(ab04b56s00.getNumape056());
		}
		if (ab04b56s00 != null && ab04b56s00.getFecpre056() != null) {
			where.append(" AND t1.FECPRE_056 = ?");
			params.add(ab04b56s00.getFecpre056());
		}
		if (ab04b56s00 != null && ab04b56s00.getFecier056() != null) {
			where.append(" AND t1.FECIER_056 = ?");
			params.add(ab04b56s00.getFecier056());
		}
		if (ab04b56s00 != null && ab04b56s00.getNueva056() != null) {
			where.append(" AND t1.NUEVA_056 = ?");
			params.add(ab04b56s00.getNueva056());
		}
		if (ab04b56s00 != null && ab04b56s00.getTipdoc056() != null) {
			where.append(" AND t1.TIPDOC_056 = ?");
			params.add(ab04b56s00.getTipdoc056());
		}
		if (ab04b56s00 != null && ab04b56s00.getNumdoc056() != null) {
			where.append(" AND t1.NUMDOC_056 = ?");
			params.add(ab04b56s00.getNumdoc056());
		}
		if (ab04b56s00 != null && ab04b56s00.getNomemp056() != null) {
			where.append(" AND t1.NOMEMP_056 = ?");
			params.add(ab04b56s00.getNomemp056());
		}
		if (ab04b56s00 != null && ab04b56s00.getProvinciaEmp() != null
				&& ab04b56s00.getProvinciaEmp().getCodProvincia() != null) {
			where.append(" AND t1.PRVEMP_056 = ?");
			params.add(ab04b56s00.getProvinciaEmp().getCodProvincia());
		}
		if (ab04b56s00 != null && ab04b56s00.getMunicipioEmp() != null
				&& ab04b56s00.getMunicipioEmp().getCodMunicipio() != null) {
			where.append(" AND t1.MUNEMP_056 = ?");
			params.add(ab04b56s00.getMunicipioEmp().getCodMunicipio());
		}
		if (ab04b56s00 != null && ab04b56s00.getDmunemp056() != null) {
			where.append(" AND t1.DMUNEMP_056 = ?");
			params.add(ab04b56s00.getDmunemp056());
		}
		if (ab04b56s00 != null && ab04b56s00.getDiremp056() != null) {
			where.append(" AND t1.DIREMP_056 = ?");
			params.add(ab04b56s00.getDiremp056());
		}
		if (ab04b56s00 != null && ab04b56s00.getCpoemp056() != null) {
			where.append(" AND t1.CPOEMP_056 = ?");
			params.add(ab04b56s00.getCpoemp056());
		}
		if (ab04b56s00 != null && ab04b56s00.getTlfemp056() != null) {
			where.append(" AND t1.TLFEMP_056 = ?");
			params.add(ab04b56s00.getTlfemp056());
		}
		if (ab04b56s00 != null && ab04b56s00.getCnaeemp056() != null) {
			where.append(" AND t1.CNAEEMP_056 = ?");
			params.add(ab04b56s00.getCnaeemp056());
		}
		if (ab04b56s00 != null && ab04b56s00.getEntiat056() != null) {
			where.append(" AND t1.ENTIAT_056 = ?");
			params.add(ab04b56s00.getEntiat056());
		}
		if (ab04b56s00 != null && ab04b56s00.getTipoApertura() != null
				&& ab04b56s00.getTipoApertura().getTipape071() != null) {
			where.append(" AND t1.TIPAPE_056 = ?");
			params.add(ab04b56s00.getTipoApertura().getTipape071());
		}
		if (ab04b56s00 != null && ab04b56s00.getNomctr056() != null) {
			where.append(" AND t1.NOMCTR_056 = ?");
			params.add(ab04b56s00.getNomctr056());
		}
		if (ab04b56s00 != null && ab04b56s00.getProvinciaCtr() != null
				&& ab04b56s00.getProvinciaCtr().getCodProvincia() != null) {
			where.append(" AND t1.PRVCTR_056 = ?");
			params.add(ab04b56s00.getProvinciaCtr().getCodProvincia());
		}
		if (ab04b56s00 != null && ab04b56s00.getMunicipioCtr() != null
				&& ab04b56s00.getMunicipioCtr().getCodMunicipio() != null) {
			where.append(" AND t1.MUNCTR_056 = ?");
			params.add(ab04b56s00.getMunicipioCtr().getCodMunicipio());
		}
		if (ab04b56s00 != null && ab04b56s00.getLocctr056() != null) {
			where.append(" AND t1.LOCCTR_056 = ?");
			params.add(ab04b56s00.getLocctr056());
		}
		if (ab04b56s00 != null && ab04b56s00.getDirctr056() != null) {
			where.append(" AND t1.DIRCTR_056 = ?");
			params.add(ab04b56s00.getDirctr056());
		}
		if (ab04b56s00 != null && ab04b56s00.getCpoctr056() != null) {
			where.append(" AND t1.CPOCTR_056 = ?");
			params.add(ab04b56s00.getCpoctr056());
		}
		if (ab04b56s00 != null && ab04b56s00.getTlfctr056() != null) {
			where.append(" AND t1.TLFCTR_056 = ?");
			params.add(ab04b56s00.getTlfctr056());
		}
		if (ab04b56s00 != null && ab04b56s00.getFaxctr056() != null) {
			where.append(" AND t1.FAXCTR_056 = ?");
			params.add(ab04b56s00.getFaxctr056());
		}
		if (ab04b56s00 != null && ab04b56s00.getEmailctr056() != null) {
			where.append(" AND t1.EMAILCTR_056 = ?");
			params.add(ab04b56s00.getEmailctr056());
		}
		if (ab04b56s00 != null && ab04b56s00.getCnaectr056() != null) {
			where.append(" AND t1.CNAECTR_056 = ?");
			params.add(ab04b56s00.getCnaectr056());
		}
		if (ab04b56s00 != null && ab04b56s00.getPrvss056() != null) {
			where.append(" AND t1.PRVSS_056 = ?");
			params.add(ab04b56s00.getPrvss056());
		}
		if (ab04b56s00 != null && ab04b56s00.getNumss056() != null) {
			where.append(" AND t1.NUMSS_056 = ?");
			params.add(ab04b56s00.getNumss056());
		}
		if (ab04b56s00 != null && ab04b56s00.getDigss056() != null) {
			where.append(" AND t1.DIGSS_056 = ?");
			params.add(ab04b56s00.getDigss056());
		}
		if (ab04b56s00 != null && ab04b56s00.getFecini056() != null) {
			where.append(" AND t1.FECINI_056 = ?");
			params.add(ab04b56s00.getFecini056());
		}
		if (ab04b56s00 != null && ab04b56s00.getTrbhom056() != null) {
			where.append(" AND t1.TRBHOM_056 = ?");
			params.add(ab04b56s00.getTrbhom056());
		}
		if (ab04b56s00 != null && ab04b56s00.getTrbmuj056() != null) {
			where.append(" AND t1.TRBMUJ_056 = ?");
			params.add(ab04b56s00.getTrbmuj056());
		}
		if (ab04b56s00 != null && ab04b56s00.getTrbtot056() != null) {
			where.append(" AND t1.TRBTOT_056 = ?");
			params.add(ab04b56s00.getTrbtot056());
		}
		if (ab04b56s00 != null && ab04b56s00.getClasctr056() != null) {
			where.append(" AND t1.CLASCTR_056 = ?");
			params.add(ab04b56s00.getClasctr056());
		}
		if (ab04b56s00 != null && ab04b56s00.getDescobr056() != null) {
			where.append(" AND t1.DESCOBR_056 = ?");
			params.add(ab04b56s00.getDescobr056());
		}
		if (ab04b56s00 != null && ab04b56s00.getSuperf056() != null) {
			where.append(" AND t1.SUPERF_056 = ?");
			params.add(ab04b56s00.getSuperf056());
		}
		if (ab04b56s00 != null && ab04b56s00.getPlanseg056() != null) {
			where.append(" AND t1.PLANSEG_056 = ?");
			params.add(ab04b56s00.getPlanseg056());
		}
		if (ab04b56s00 != null && ab04b56s00.getCanalplan056() != null) {
			where.append(" AND t1.CANALPLAN_056 = ?");
			params.add(ab04b56s00.getCanalplan056());
		}
		if (ab04b56s00 != null && ab04b56s00.getPlanpres056() != null) {
			where.append(" AND t1.PLANPRES_056 = ?");
			params.add(ab04b56s00.getPlanpres056());
		}
		if (ab04b56s00 != null && ab04b56s00.getProytec056() != null) {
			where.append(" AND t1.PROYTEC_056 = ?");
			params.add(ab04b56s00.getProytec056());
		}
		if (ab04b56s00 != null && ab04b56s00.getDescmaq056() != null) {
			where.append(" AND t1.DESCMAQ_056 = ?");
			params.add(ab04b56s00.getDescmaq056());
		}
		if (ab04b56s00 != null && ab04b56s00.getPoten056() != null) {
			where.append(" AND t1.POTEN_056 = ?");
			params.add(ab04b56s00.getPoten056());
		}
		if (ab04b56s00 != null && ab04b56s00.getIndanx056() != null) {
			where.append(" AND t1.INDANX_056 = ?");
			params.add(ab04b56s00.getIndanx056());
		}
		if (ab04b56s00 != null && ab04b56s00.getApdoanx056() != null) {
			where.append(" AND t1.APDOANX_056 = ?");
			params.add(ab04b56s00.getApdoanx056());
		}
		if (ab04b56s00 != null && ab04b56s00.getDestrab056() != null) {
			where.append(" AND t1.DESTRAB_056 = ?");
			params.add(ab04b56s00.getDestrab056());
		}
		if (ab04b56s00 != null && ab04b56s00.getIndobra056() != null) {
			where.append(" AND t1.INDOBRA_056 = ?");
			params.add(ab04b56s00.getIndobra056());
		}
		if (ab04b56s00 != null && ab04b56s00.getCodobra056() != null) {
			where.append(" AND t1.CODOBRA_056 = ?");
			params.add(ab04b56s00.getCodobra056());
		}
		if (ab04b56s00 != null && ab04b56s00.getCodctr056() != null) {
			where.append(" AND t1.CODCTR_056 = ?");
			params.add(ab04b56s00.getCodctr056());
		}
		if (ab04b56s00 != null && ab04b56s00.getLotemnt056() != null) {
			where.append(" AND t1.LOTEMNT_056 = ?");
			params.add(ab04b56s00.getLotemnt056());
		}
		if (ab04b56s00 != null && ab04b56s00.getVisosl056() != null) {
			where.append(" AND t1.VISOSL_056 = ?");
			params.add(ab04b56s00.getVisosl056());
		}
		if (ab04b56s00 != null && ab04b56s00.getAsgosl056() != null) {
			where.append(" AND t1.ASGOSL_056 = ?");
			params.add(ab04b56s00.getAsgosl056());
		}
		if (ab04b56s00 != null && ab04b56s00.getTecosl056() != null) {
			where.append(" AND t1.TECOSL_056 = ?");
			params.add(ab04b56s00.getTecosl056());
		}
		if (ab04b56s00 != null && ab04b56s00.getFvisosl056() != null) {
			where.append(" AND t1.FVISOSL_056 = ?");
			params.add(ab04b56s00.getFvisosl056());
		}
		if (ab04b56s00 != null && ab04b56s00.getVisins056() != null) {
			where.append(" AND t1.VISINS_056 = ?");
			params.add(ab04b56s00.getVisins056());
		}
		if (ab04b56s00 != null && ab04b56s00.getAsgins056() != null) {
			where.append(" AND t1.ASGINS_056 = ?");
			params.add(ab04b56s00.getAsgins056());
		}
		if (ab04b56s00 != null && ab04b56s00.getTecins056() != null) {
			where.append(" AND t1.TECINS_056 = ?");
			params.add(ab04b56s00.getTecins056());
		}
		if (ab04b56s00 != null && ab04b56s00.getFvisins056() != null) {
			where.append(" AND t1.FVISINS_056 = ?");
			params.add(ab04b56s00.getFvisins056());
		}
		if (ab04b56s00 != null && ab04b56s00.getFecinsp056() != null) {
			where.append(" AND t1.FECINSP_056 = ?");
			params.add(ab04b56s00.getFecinsp056());
		}
		if (ab04b56s00 != null && ab04b56s00.getFecreq056() != null) {
			where.append(" AND t1.FECREQ_056 = ?");
			params.add(ab04b56s00.getFecreq056());
		}
		if (ab04b56s00 != null && ab04b56s00.getFecsub056() != null) {
			where.append(" AND t1.FECSUB_056 = ?");
			params.add(ab04b56s00.getFecsub056());
		}
		if (ab04b56s00 != null && ab04b56s00.getFinfosl056() != null) {
			where.append(" AND t1.FINFOSL_056 = ?");
			params.add(ab04b56s00.getFinfosl056());
		}
		if (ab04b56s00 != null && ab04b56s00.getFinfinsp056() != null) {
			where.append(" AND t1.FINFINSP_056 = ?");
			params.add(ab04b56s00.getFinfinsp056());
		}
		if (ab04b56s00 != null && ab04b56s00.getFecalt056() != null) {
			where.append(" AND t1.FECALT_056 = ?");
			params.add(ab04b56s00.getFecalt056());
		}
		if (ab04b56s00 != null && ab04b56s00.getUsualt056() != null) {
			where.append(" AND t1.USUALT_056 = ?");
			params.add(ab04b56s00.getUsualt056());
		}
		if (ab04b56s00 != null && ab04b56s00.getFecmod056() != null) {
			where.append(" AND t1.FECMOD_056 = ?");
			params.add(ab04b56s00.getFecmod056());
		}
		if (ab04b56s00 != null && ab04b56s00.getUsumod056() != null) {
			where.append(" AND t1.USUMOD_056 = ?");
			params.add(ab04b56s00.getUsumod056());
		}
		if (ab04b56s00 != null && ab04b56s00.getDoccorrecta056() != null) {
			where.append(" AND t1.DOCCORRECTA_056 = ?");
			params.add(ab04b56s00.getDoccorrecta056());
		}
		if (ab04b56s00 != null && ab04b56s00.getCodentiat056() != null) {
			where.append(" AND t1.CODENTIAT_056 = ?");
			params.add(ab04b56s00.getCodentiat056());
		}
		if (ab04b56s00 != null && ab04b56s00.getEstadocier056() != null) {
			where.append(" AND t1.ESTADOCIER_056 = ?");
			params.add(ab04b56s00.getEstadocier056());
		}
		if (ab04b56s00 != null && ab04b56s00.getEstado056() != null) {
			where.append(" AND t1.ESTADO_056 = ?");
			params.add(ab04b56s00.getEstado056());
		}
		if (ab04b56s00 != null && ab04b56s00.getCnaectr93056() != null) {
			where.append(" AND t1.CNAECTR93_056 = ?");
			params.add(ab04b56s00.getCnaectr93056());
		}
		if (ab04b56s00 != null && ab04b56s00.getCnaeemp93056() != null) {
			where.append(" AND t1.CNAEEMP93_056 = ?");
			params.add(ab04b56s00.getCnaeemp93056());
		}
		if (ab04b56s00 != null && ab04b56s00.getModpre056() != null) {
			where.append(" AND t1.MODPRE_056 = ?");
			params.add(ab04b56s00.getModpre056());
		}
		if (ab04b56s00 != null && ab04b56s00.getNumcnt056() != null) {
			where.append(" AND t1.NUMCNT_056 = ?");
			params.add(ab04b56s00.getNumcnt056());
		}
		if (ab04b56s00 != null && ab04b56s00.getIdape056() != null) {
			where.append(" AND t1.IDAPE_056 = ?");
			params.add(ab04b56s00.getIdape056());
		}
		if (ab04b56s00 != null && ab04b56s00.getEvalpres056() != null) {
			where.append(" AND t1.EVALPRES_056 = ?");
			params.add(ab04b56s00.getEvalpres056());
		}
		if (ab04b56s00 != null && ab04b56s00.getCanaleval056() != null) {
			where.append(" AND t1.CANALEVAL_056 = ?");
			params.add(ab04b56s00.getCanaleval056());
		}
		if (ab04b56s00 != null && ab04b56s00.getRegemp056() != null) {
			where.append(" AND t1.REGEMP_056 = ?");
			params.add(ab04b56s00.getRegemp056());
		}
		if (ab04b56s00 != null
				&& ab04b56s00.getNumdocrepresentante056() != null) {
			where.append(" AND t1.NUMDOCREPRESENTANTE_056 = ?");
			params.add(ab04b56s00.getNumdocrepresentante056());
		}
		if (ab04b56s00 != null
				&& ab04b56s00.getNombrerepresentante056() != null) {
			where.append(" AND t1.NOMREPRESENTANTE_056 = ?");
			params.add(ab04b56s00.getNombrerepresentante056());
		}
		if (ab04b56s00 != null
				&& ab04b56s00.getTipdocrepresentante056() != null) {
			where.append(" AND t1.TIPDOCREPRESENTANTE_056 = ?");
			params.add(ab04b56s00.getTipdocrepresentante056());
		}
		if (ab04b56s00 != null && ab04b56s00.getTlfrepresentante056() != null) {
			where.append(" AND t1.TLFREPRESENTANTE_056 = ?");
			params.add(ab04b56s00.getTlfrepresentante056());
		}
		if (ab04b56s00 != null && ab04b56s00.getTerape056() != null) {
			where.append(" AND t1.TERAPE_056 = ?");
			params.add(ab04b56s00.getTerape056());
		}
		if (ab04b56s00 != null && ab04b56s00.getForpre056() != null) {
			where.append(" AND t1.FORPRE_056 = ?");
			params.add(ab04b56s00.getForpre056());
		}
		if (ab04b56s00 != null && ab04b56s00.getFolderId056() != null) {
			where.append(" AND t1.FOLDER_ID_056 = ?");
			params.add(ab04b56s00.getFolderId056());
		}
		if (ab04b56s00 != null && ab04b56s00.getDatosNotificacion() != null
				&& ab04b56s00.getDatosNotificacion()
						.getCodDatosNotif066() != null) {
			where.append(" AND t1.COD_DATOS_NOTIF_056 = ?");
			params.add(ab04b56s00.getDatosNotificacion().getCodDatosNotif066());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Ab04b56s00 entity.
	 * 
	 * ab04b56s00 Ab04b56s00 Bean with the criteria values to filter by.
	 * startsWith Boolean Map created with two keys key query stores the sql
	 * query syntax key params stores the parameter values to be used in the
	 * condition sentence.
	 * 
	 * @param ab04b56s00
	 *            the ab 04 b 56 s 00
	 * @param startsWith
	 *            the starts with
	 * @return the where like map
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, Object> getWhereLikeMap(ComunicacionApertura ab04b56s00,
			Boolean startsWith) {

		String mascara = Utilities.getInstance().getDateMask();

		StringBuilder where = new StringBuilder(
				ComunicacionAperturaDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (ab04b56s00 != null && ab04b56s00.getAnoape056() != null) {
			where.append(" AND UPPER(t1.ANOAPE_056) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab04b56s00.getAnoape056().toUpperCase() + "%");
			} else {
				params.add("%" + ab04b56s00.getAnoape056().toUpperCase() + "%");
			}
			where.append(" AND t1.ANOAPE_056 IS NOT NULL");
		}
		if (ab04b56s00 != null && ab04b56s00.getNumape056() != null) {
			where.append(" AND t1.NUMAPE_056 = ?");
			params.add(ab04b56s00.getNumape056());
		}
		if (ab04b56s00 != null && ab04b56s00.getNumExpDesde() != null) {
			where.append(" AND t1.NUMAPE_056 < ?");
			params.add(ab04b56s00.getNumExpDesde());
		}
		if (ab04b56s00 != null && ab04b56s00.getNumExpHasta() != null) {
			where.append(" AND t1.NUMAPE_056 > ?");
			params.add(ab04b56s00.getNumExpHasta());
		}
		if (ab04b56s00 != null && ab04b56s00.getFecpre056() != null) {
			where.append(" AND t1.FECPRE_056 = ?");
			params.add(ab04b56s00.getFecpre056());
		}
		if (ab04b56s00 != null && ab04b56s00.getFecpreDesde() != null) {
			where.append(" AND TRUNC(t1.FECPRE_056) >= trunc(to_date(?, ?)) ");
			params.add(ab04b56s00.getFecpreDesdeStr());
			params.add(mascara);
		}
		if (ab04b56s00 != null && ab04b56s00.getFecpreHasta() != null) {
			where.append(" AND TRUNC(t1.FECPRE_056) <= trunc(to_date(?, ?)) ");
			params.add(ab04b56s00.getFecpreHastaStr());
			params.add(mascara);
		}

		if (ab04b56s00 != null && ab04b56s00.getFecier056() != null) {
			where.append(" AND t1.FECIER_056 = ?");
			params.add(ab04b56s00.getFecier056());
		}
		if (ab04b56s00 != null && ab04b56s00.getNueva056() != null) {
			where.append(" AND UPPER(t1.NUEVA_056) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab04b56s00.getNueva056().toUpperCase() + "%");
			} else {
				params.add("%" + ab04b56s00.getNueva056().toUpperCase() + "%");
			}
			where.append(" AND t1.NUEVA_056 IS NOT NULL");
		}
		if (ab04b56s00 != null && ab04b56s00.getTipdoc056() != null) {
			where.append(" AND UPPER(t1.TIPDOC_056) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab04b56s00.getTipdoc056().toUpperCase() + "%");
			} else {
				params.add("%" + ab04b56s00.getTipdoc056().toUpperCase() + "%");
			}
			where.append(" AND t1.TIPDOC_056 IS NOT NULL");
		}
		if (ab04b56s00 != null && ab04b56s00.getNumdoc056() != null) {
			where.append(" AND UPPER(t1.NUMDOC_056) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab04b56s00.getNumdoc056().toUpperCase() + "%");
			} else {
				params.add("%" + ab04b56s00.getNumdoc056().toUpperCase() + "%");
			}
			where.append(" AND t1.NUMDOC_056 IS NOT NULL");
		}
		if (ab04b56s00 != null && ab04b56s00.getNomemp056() != null) {
			where.append(" AND UPPER(t1.NOMEMP_056) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab04b56s00.getNomemp056().toUpperCase() + "%");
			} else {
				params.add("%" + ab04b56s00.getNomemp056().toUpperCase() + "%");
			}
			where.append(" AND t1.NOMEMP_056 IS NOT NULL");
		}
		if (ab04b56s00 != null && ab04b56s00.getProvinciaEmp() != null
				&& ab04b56s00.getProvinciaEmp().getCodProvincia() != null) {
			where.append(" AND UPPER(t1.PRVEMP_056) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab04b56s00.getProvinciaEmp().getCodProvincia()
						.toUpperCase() + "%");
			} else {
				params.add("%" + ab04b56s00.getProvinciaEmp().getCodProvincia()
						.toUpperCase() + "%");
			}
			where.append(" AND t1.PRVEMP_056 IS NOT NULL");
		}
		if (ab04b56s00 != null && ab04b56s00.getMunicipioEmp() != null
				&& ab04b56s00.getMunicipioEmp().getCodMunicipio() != null) {
			where.append(" AND UPPER(t1.MUNEMP_056) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab04b56s00.getMunicipioEmp().getCodMunicipio()
						.toUpperCase() + "%");
			} else {
				params.add("%" + ab04b56s00.getMunicipioEmp().getCodMunicipio()
						.toUpperCase() + "%");
			}
			where.append(" AND t1.MUNEMP_056 IS NOT NULL");
		}
		if (ab04b56s00 != null && ab04b56s00.getDmunemp056() != null) {
			where.append(" AND UPPER(t1.DMUNEMP_056) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab04b56s00.getDmunemp056().toUpperCase() + "%");
			} else {
				params.add(
						"%" + ab04b56s00.getDmunemp056().toUpperCase() + "%");
			}
			where.append(" AND t1.DMUNEMP_056 IS NOT NULL");
		}
		if (ab04b56s00 != null && ab04b56s00.getDiremp056() != null) {
			where.append(" AND UPPER(t1.DIREMP_056) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab04b56s00.getDiremp056().toUpperCase() + "%");
			} else {
				params.add("%" + ab04b56s00.getDiremp056().toUpperCase() + "%");
			}
			where.append(" AND t1.DIREMP_056 IS NOT NULL");
		}
		if (ab04b56s00 != null && ab04b56s00.getCpoemp056() != null) {
			where.append(" AND UPPER(t1.CPOEMP_056) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab04b56s00.getCpoemp056().toUpperCase() + "%");
			} else {
				params.add("%" + ab04b56s00.getCpoemp056().toUpperCase() + "%");
			}
			where.append(" AND t1.CPOEMP_056 IS NOT NULL");
		}
		if (ab04b56s00 != null && ab04b56s00.getTlfemp056() != null) {
			where.append(" AND UPPER(t1.TLFEMP_056) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab04b56s00.getTlfemp056().toUpperCase() + "%");
			} else {
				params.add("%" + ab04b56s00.getTlfemp056().toUpperCase() + "%");
			}
			where.append(" AND t1.TLFEMP_056 IS NOT NULL");
		}
		if (ab04b56s00 != null && ab04b56s00.getCnaeemp056() != null) {
			where.append(" AND UPPER(t1.CNAEEMP_056) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab04b56s00.getCnaeemp056().toUpperCase() + "%");
			} else {
				params.add(
						"%" + ab04b56s00.getCnaeemp056().toUpperCase() + "%");
			}
			where.append(" AND t1.CNAEEMP_056 IS NOT NULL");
		}
		if (ab04b56s00 != null && ab04b56s00.getEntiat056() != null) {
			where.append(" AND UPPER(t1.ENTIAT_056) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab04b56s00.getEntiat056().toUpperCase() + "%");
			} else {
				params.add("%" + ab04b56s00.getEntiat056().toUpperCase() + "%");
			}
			where.append(" AND t1.ENTIAT_056 IS NOT NULL");
		}
		if (ab04b56s00 != null && ab04b56s00.getTipoApertura() != null
				&& ab04b56s00.getTipoApertura().getTipape071() != null) {
			where.append(" AND UPPER(t1.TIPAPE_056) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab04b56s00.getTipoApertura().getTipape071()
						.toUpperCase() + "%");
			} else {
				params.add("%" + ab04b56s00.getTipoApertura().getTipape071()
						.toUpperCase() + "%");
			}
			where.append(" AND t1.TIPAPE_056 IS NOT NULL");
		}
		if (ab04b56s00 != null && ab04b56s00.getNomctr056() != null) {
			where.append(" AND UPPER(t1.NOMCTR_056) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab04b56s00.getNomctr056().toUpperCase() + "%");
			} else {
				params.add("%" + ab04b56s00.getNomctr056().toUpperCase() + "%");
			}
			where.append(" AND t1.NOMCTR_056 IS NOT NULL");
		}
		if (ab04b56s00 != null && ab04b56s00.getProvinciaCtr() != null
				&& ab04b56s00.getProvinciaCtr().getCodProvincia() != null) {
			where.append(" AND UPPER(t1.PRVCTR_056) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab04b56s00.getProvinciaCtr().getCodProvincia()
						.toUpperCase() + "%");
			} else {
				params.add("%" + ab04b56s00.getProvinciaCtr().getCodProvincia()
						.toUpperCase() + "%");
			}
			where.append(" AND t1.PRVCTR_056 IS NOT NULL");
		}
		if (ab04b56s00 != null && ab04b56s00.getMunicipioCtr() != null
				&& ab04b56s00.getMunicipioCtr().getCodMunicipio() != null) {
			where.append(" AND UPPER(t1.MUNCTR_056) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab04b56s00.getMunicipioCtr().getCodMunicipio()
						.toUpperCase() + "%");
			} else {
				params.add("%" + ab04b56s00.getMunicipioCtr().getCodMunicipio()
						.toUpperCase() + "%");
			}
			where.append(" AND t1.MUNCTR_056 IS NOT NULL");
		}
		if (ab04b56s00 != null && ab04b56s00.getLocctr056() != null) {
			where.append(" AND UPPER(t1.LOCCTR_056) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab04b56s00.getLocctr056().toUpperCase() + "%");
			} else {
				params.add("%" + ab04b56s00.getLocctr056().toUpperCase() + "%");
			}
			where.append(" AND t1.LOCCTR_056 IS NOT NULL");
		}
		if (ab04b56s00 != null && ab04b56s00.getDirctr056() != null) {
			where.append(" AND UPPER(t1.DIRCTR_056) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab04b56s00.getDirctr056().toUpperCase() + "%");
			} else {
				params.add("%" + ab04b56s00.getDirctr056().toUpperCase() + "%");
			}
			where.append(" AND t1.DIRCTR_056 IS NOT NULL");
		}
		if (ab04b56s00 != null && ab04b56s00.getCpoctr056() != null) {
			where.append(" AND UPPER(t1.CPOCTR_056) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab04b56s00.getCpoctr056().toUpperCase() + "%");
			} else {
				params.add("%" + ab04b56s00.getCpoctr056().toUpperCase() + "%");
			}
			where.append(" AND t1.CPOCTR_056 IS NOT NULL");
		}
		if (ab04b56s00 != null && ab04b56s00.getTlfctr056() != null) {
			where.append(" AND UPPER(t1.TLFCTR_056) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab04b56s00.getTlfctr056().toUpperCase() + "%");
			} else {
				params.add("%" + ab04b56s00.getTlfctr056().toUpperCase() + "%");
			}
			where.append(" AND t1.TLFCTR_056 IS NOT NULL");
		}
		if (ab04b56s00 != null && ab04b56s00.getFaxctr056() != null) {
			where.append(" AND UPPER(t1.FAXCTR_056) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab04b56s00.getFaxctr056().toUpperCase() + "%");
			} else {
				params.add("%" + ab04b56s00.getFaxctr056().toUpperCase() + "%");
			}
			where.append(" AND t1.FAXCTR_056 IS NOT NULL");
		}
		if (ab04b56s00 != null && ab04b56s00.getEmailctr056() != null) {
			where.append(" AND UPPER(t1.EMAILCTR_056) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab04b56s00.getEmailctr056().toUpperCase() + "%");
			} else {
				params.add(
						"%" + ab04b56s00.getEmailctr056().toUpperCase() + "%");
			}
			where.append(" AND t1.EMAILCTR_056 IS NOT NULL");
		}
		if (ab04b56s00 != null && ab04b56s00.getCnaectr056() != null) {
			where.append(" AND UPPER(t1.CNAECTR_056) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab04b56s00.getCnaectr056().toUpperCase() + "%");
			} else {
				params.add(
						"%" + ab04b56s00.getCnaectr056().toUpperCase() + "%");
			}
			where.append(" AND t1.CNAECTR_056 IS NOT NULL");
		}
		if (ab04b56s00 != null && ab04b56s00.getPrvss056() != null) {
			where.append(" AND UPPER(t1.PRVSS_056) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab04b56s00.getPrvss056().toUpperCase() + "%");
			} else {
				params.add("%" + ab04b56s00.getPrvss056().toUpperCase() + "%");
			}
			where.append(" AND t1.PRVSS_056 IS NOT NULL");
		}
		if (ab04b56s00 != null && ab04b56s00.getNumss056() != null) {
			where.append(" AND UPPER(t1.NUMSS_056) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab04b56s00.getNumss056().toUpperCase() + "%");
			} else {
				params.add("%" + ab04b56s00.getNumss056().toUpperCase() + "%");
			}
			where.append(" AND t1.NUMSS_056 IS NOT NULL");
		}
		if (ab04b56s00 != null && ab04b56s00.getDigss056() != null) {
			where.append(" AND UPPER(t1.DIGSS_056) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab04b56s00.getDigss056().toUpperCase() + "%");
			} else {
				params.add("%" + ab04b56s00.getDigss056().toUpperCase() + "%");
			}
			where.append(" AND t1.DIGSS_056 IS NOT NULL");
		}
		if (ab04b56s00 != null && ab04b56s00.getFecini056() != null) {
			where.append(" AND t1.FECINI_056 = ?");
			params.add(ab04b56s00.getFecini056());
		}
		if (ab04b56s00 != null && ab04b56s00.getTrbhom056() != null) {
			where.append(" AND t1.TRBHOM_056 = ?");
			params.add(ab04b56s00.getTrbhom056());
		}
		if (ab04b56s00 != null && ab04b56s00.getTrbmuj056() != null) {
			where.append(" AND t1.TRBMUJ_056 = ?");
			params.add(ab04b56s00.getTrbmuj056());
		}
		if (ab04b56s00 != null && ab04b56s00.getTrbtot056() != null) {
			where.append(" AND t1.TRBTOT_056 = ?");
			params.add(ab04b56s00.getTrbtot056());
		}
		if (ab04b56s00 != null && ab04b56s00.getTrbTotDesde() != null) {
			where.append(" AND t1.TRBTOT_056 >= ?");
			params.add(ab04b56s00.getTrbTotDesde());
		}
		if (ab04b56s00 != null && ab04b56s00.getTrbTotHasta() != null) {
			where.append(" AND t1.TRBTOT_056 <= ?");
			params.add(ab04b56s00.getTrbTotHasta());
		}

		if (ab04b56s00 != null && ab04b56s00.getClasctr056() != null) {
			where.append(" AND UPPER(t1.CLASCTR_056) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab04b56s00.getClasctr056().toUpperCase() + "%");
			} else {
				params.add(
						"%" + ab04b56s00.getClasctr056().toUpperCase() + "%");
			}
			where.append(" AND t1.CLASCTR_056 IS NOT NULL");
		}
		if (ab04b56s00 != null && ab04b56s00.getDescobr056() != null) {
			where.append(" AND UPPER(t1.DESCOBR_056) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab04b56s00.getDescobr056().toUpperCase() + "%");
			} else {
				params.add(
						"%" + ab04b56s00.getDescobr056().toUpperCase() + "%");
			}
			where.append(" AND t1.DESCOBR_056 IS NOT NULL");
		}
		if (ab04b56s00 != null && ab04b56s00.getSuperf056() != null) {
			where.append(" AND t1.SUPERF_056 = ?");
			params.add(ab04b56s00.getSuperf056());
		}
		if (ab04b56s00 != null && ab04b56s00.getPlanseg056() != null) {
			where.append(" AND UPPER(t1.PLANSEG_056) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab04b56s00.getPlanseg056().toUpperCase() + "%");
			} else {
				params.add(
						"%" + ab04b56s00.getPlanseg056().toUpperCase() + "%");
			}
			where.append(" AND t1.PLANSEG_056 IS NOT NULL");
		}
		if (ab04b56s00 != null && ab04b56s00.getCanalplan056() != null) {
			where.append(" AND UPPER(t1.CANALPLAN_056) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab04b56s00.getCanalplan056().toUpperCase() + "%");
			} else {
				params.add(
						"%" + ab04b56s00.getCanalplan056().toUpperCase() + "%");
			}
			where.append(" AND t1.CANALPLAN_056 IS NOT NULL");
		}
		if (ab04b56s00 != null && ab04b56s00.getPlanpres056() != null) {
			where.append(" AND UPPER(t1.PLANPRES_056) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab04b56s00.getPlanpres056().toUpperCase() + "%");
			} else {
				params.add(
						"%" + ab04b56s00.getPlanpres056().toUpperCase() + "%");
			}
			where.append(" AND t1.PLANPRES_056 IS NOT NULL");
		}
		if (ab04b56s00 != null && ab04b56s00.getProytec056() != null) {
			where.append(" AND UPPER(t1.PROYTEC_056) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab04b56s00.getProytec056().toUpperCase() + "%");
			} else {
				params.add(
						"%" + ab04b56s00.getProytec056().toUpperCase() + "%");
			}
			where.append(" AND t1.PROYTEC_056 IS NOT NULL");
		}
		if (ab04b56s00 != null && ab04b56s00.getDescmaq056() != null) {
			where.append(" AND UPPER(t1.DESCMAQ_056) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab04b56s00.getDescmaq056().toUpperCase() + "%");
			} else {
				params.add(
						"%" + ab04b56s00.getDescmaq056().toUpperCase() + "%");
			}
			where.append(" AND t1.DESCMAQ_056 IS NOT NULL");
		}
		if (ab04b56s00 != null && ab04b56s00.getPoten056() != null) {
			where.append(" AND t1.POTEN_056 = ?");
			params.add(ab04b56s00.getPoten056());
		}
		if (ab04b56s00 != null && ab04b56s00.getIndanx056() != null) {
			where.append(" AND UPPER(t1.INDANX_056) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab04b56s00.getIndanx056().toUpperCase() + "%");
			} else {
				params.add("%" + ab04b56s00.getIndanx056().toUpperCase() + "%");
			}
			where.append(" AND t1.INDANX_056 IS NOT NULL");
		}
		if (ab04b56s00 != null && ab04b56s00.getApdoanx056() != null) {
			where.append(" AND UPPER(t1.APDOANX_056) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab04b56s00.getApdoanx056().toUpperCase() + "%");
			} else {
				params.add(
						"%" + ab04b56s00.getApdoanx056().toUpperCase() + "%");
			}
			where.append(" AND t1.APDOANX_056 IS NOT NULL");
		}
		if (ab04b56s00 != null && ab04b56s00.getDestrab056() != null) {
			where.append(" AND UPPER(t1.DESTRAB_056) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab04b56s00.getDestrab056().toUpperCase() + "%");
			} else {
				params.add(
						"%" + ab04b56s00.getDestrab056().toUpperCase() + "%");
			}
			where.append(" AND t1.DESTRAB_056 IS NOT NULL");
		}
		if (ab04b56s00 != null && ab04b56s00.getIndobra056() != null) {
			where.append(" AND UPPER(t1.INDOBRA_056) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab04b56s00.getIndobra056().toUpperCase() + "%");
			} else {
				params.add(
						"%" + ab04b56s00.getIndobra056().toUpperCase() + "%");
			}
			where.append(" AND t1.INDOBRA_056 IS NOT NULL");
		}
		if (ab04b56s00 != null && ab04b56s00.getCodobra056() != null) {
			where.append(" AND t1.CODOBRA_056 = ?");
			params.add(ab04b56s00.getCodobra056());
		}
		if (ab04b56s00 != null && ab04b56s00.getCodctr056() != null) {
			where.append(" AND t1.CODCTR_056 = ?");
			params.add(ab04b56s00.getCodctr056());
		}
		if (ab04b56s00 != null && ab04b56s00.getLotemnt056() != null) {
			where.append(" AND UPPER(t1.LOTEMNT_056) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab04b56s00.getLotemnt056().toUpperCase() + "%");
			} else {
				params.add(
						"%" + ab04b56s00.getLotemnt056().toUpperCase() + "%");
			}
			where.append(" AND t1.LOTEMNT_056 IS NOT NULL");
		}
		if (ab04b56s00 != null && ab04b56s00.getVisosl056() != null) {
			where.append(" AND UPPER(t1.VISOSL_056) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab04b56s00.getVisosl056().toUpperCase() + "%");
			} else {
				params.add("%" + ab04b56s00.getVisosl056().toUpperCase() + "%");
			}
			where.append(" AND t1.VISOSL_056 IS NOT NULL");
		}
		if (ab04b56s00 != null && ab04b56s00.getAsgosl056() != null) {
			where.append(" AND UPPER(t1.ASGOSL_056) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab04b56s00.getAsgosl056().toUpperCase() + "%");
			} else {
				params.add("%" + ab04b56s00.getAsgosl056().toUpperCase() + "%");
			}
			where.append(" AND t1.ASGOSL_056 IS NOT NULL");
		}
		if (ab04b56s00 != null && ab04b56s00.getTecosl056() != null) {
			where.append(" AND UPPER(t1.TECOSL_056) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab04b56s00.getTecosl056().toUpperCase() + "%");
			} else {
				params.add("%" + ab04b56s00.getTecosl056().toUpperCase() + "%");
			}
			where.append(" AND t1.TECOSL_056 IS NOT NULL");
		}
		if (ab04b56s00 != null && ab04b56s00.getFvisosl056() != null) {
			where.append(" AND t1.FVISOSL_056 = ?");
			params.add(ab04b56s00.getFvisosl056());
		}
		if (ab04b56s00 != null && ab04b56s00.getVisins056() != null) {
			where.append(" AND UPPER(t1.VISINS_056) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab04b56s00.getVisins056().toUpperCase() + "%");
			} else {
				params.add("%" + ab04b56s00.getVisins056().toUpperCase() + "%");
			}
			where.append(" AND t1.VISINS_056 IS NOT NULL");
		}
		if (ab04b56s00 != null && ab04b56s00.getAsgins056() != null) {
			where.append(" AND UPPER(t1.ASGINS_056) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab04b56s00.getAsgins056().toUpperCase() + "%");
			} else {
				params.add("%" + ab04b56s00.getAsgins056().toUpperCase() + "%");
			}
			where.append(" AND t1.ASGINS_056 IS NOT NULL");
		}
		if (ab04b56s00 != null && ab04b56s00.getTecins056() != null) {
			where.append(" AND UPPER(t1.TECINS_056) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab04b56s00.getTecins056().toUpperCase() + "%");
			} else {
				params.add("%" + ab04b56s00.getTecins056().toUpperCase() + "%");
			}
			where.append(" AND t1.TECINS_056 IS NOT NULL");
		}
		if (ab04b56s00 != null && ab04b56s00.getFvisins056() != null) {
			where.append(" AND t1.FVISINS_056 = ?");
			params.add(ab04b56s00.getFvisins056());
		}
		if (ab04b56s00 != null && ab04b56s00.getFecinsp056() != null) {
			where.append(" AND t1.FECINSP_056 = ?");
			params.add(ab04b56s00.getFecinsp056());
		}
		if (ab04b56s00 != null && ab04b56s00.getFecreq056() != null) {
			where.append(" AND t1.FECREQ_056 = ?");
			params.add(ab04b56s00.getFecreq056());
		}
		if (ab04b56s00 != null && ab04b56s00.getFecsub056() != null) {
			where.append(" AND t1.FECSUB_056 = ?");
			params.add(ab04b56s00.getFecsub056());
		}
		if (ab04b56s00 != null && ab04b56s00.getFinfosl056() != null) {
			where.append(" AND t1.FINFOSL_056 = ?");
			params.add(ab04b56s00.getFinfosl056());
		}
		if (ab04b56s00 != null && ab04b56s00.getIndInfOsalan() != null) {
			if (Constantes.VALUE_SI.equals(ab04b56s00.getIndInfOsalan())) {
				where.append(" AND t1.FINFOSL_056 IS NOT NULL");
			} else if (Constantes.VALUE_NO
					.equals(ab04b56s00.getIndInfOsalan())) {
				where.append(" AND t1.FINFOSL_056 IS NULL");
			}
		}

		if (ab04b56s00 != null && ab04b56s00.getFinfinsp056() != null) {
			where.append(" AND t1.FINFINSP_056 = ?");
			params.add(ab04b56s00.getFinfinsp056());
		}
		if (ab04b56s00 != null && ab04b56s00.getIndInfInsp() != null) {
			if (Constantes.VALUE_SI.equals(ab04b56s00.getIndInfInsp())) {
				where.append(" AND t1.FINFINSP_056 IS NOT NULL");
			} else if (Constantes.VALUE_NO.equals(ab04b56s00.getIndInfInsp())) {
				where.append(" AND t1.FINFINSP_056 IS NULL");
			}
		}

		if (ab04b56s00 != null && ab04b56s00.getFecalt056() != null) {
			where.append(" AND t1.FECALT_056 = ?");
			params.add(ab04b56s00.getFecalt056());
		}
		if (ab04b56s00 != null && ab04b56s00.getUsualt056() != null) {
			where.append(" AND UPPER(t1.USUALT_056) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab04b56s00.getUsualt056().toUpperCase() + "%");
			} else {
				params.add("%" + ab04b56s00.getUsualt056().toUpperCase() + "%");
			}
			where.append(" AND t1.USUALT_056 IS NOT NULL");
		}
		if (ab04b56s00 != null && ab04b56s00.getFecmod056() != null) {
			where.append(" AND t1.FECMOD_056 = ?");
			params.add(ab04b56s00.getFecmod056());
		}

		if (ab04b56s00 != null && ab04b56s00.getFecmodifDesde() != null) {
			where.append(" AND TRUNC(t1.FECMOD_056) >= trunc(to_date(?, ?)) ");
			params.add(ab04b56s00.getFecmodifDesdeStr());
			params.add(mascara);
		}
		if (ab04b56s00 != null && ab04b56s00.getFecmodifDesde() != null) {
			where.append(" AND TRUNC(t1.FECMOD_056) <= trunc(to_date(?, ?)) ");
			params.add(ab04b56s00.getFecmodifDesdeStr());
			params.add(mascara);
		}

		if (ab04b56s00 != null && ab04b56s00.getUsumod056() != null) {
			where.append(" AND UPPER(t1.USUMOD_056) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab04b56s00.getUsumod056().toUpperCase() + "%");
			} else {
				params.add("%" + ab04b56s00.getUsumod056().toUpperCase() + "%");
			}
			where.append(" AND t1.USUMOD_056 IS NOT NULL");
		}

		if (ab04b56s00 != null && ab04b56s00.getDoccorrecta056() != null) {
			where.append(" AND UPPER(t1.DOCCORRECTA_056) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab04b56s00.getDoccorrecta056().toUpperCase() + "%");
			} else {
				params.add("%" + ab04b56s00.getDoccorrecta056().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.DOCCORRECTA_056 IS NOT NULL");
		}
		if (ab04b56s00 != null && ab04b56s00.getCodentiat056() != null) {
			where.append(" AND UPPER(t1.CODENTIAT_056) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab04b56s00.getCodentiat056().toUpperCase() + "%");
			} else {
				params.add(
						"%" + ab04b56s00.getCodentiat056().toUpperCase() + "%");
			}
			where.append(" AND t1.CODENTIAT_056 IS NOT NULL");
		}
		if (ab04b56s00 != null && ab04b56s00.getEstadocier056() != null) {
			where.append(" AND UPPER(t1.ESTADOCIER_056) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab04b56s00.getEstadocier056().toUpperCase() + "%");
			} else {
				params.add("%" + ab04b56s00.getEstadocier056().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.ESTADOCIER_056 IS NOT NULL");
		}
		if (ab04b56s00 != null && ab04b56s00.getEstado056() != null) {
			where.append(" AND UPPER(t1.ESTADO_056) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab04b56s00.getEstado056().toUpperCase() + "%");
			} else {
				params.add("%" + ab04b56s00.getEstado056().toUpperCase() + "%");
			}
			where.append(" AND t1.ESTADO_056 IS NOT NULL");
		}
		if (ab04b56s00 != null && ab04b56s00.getCnaectr93056() != null) {
			where.append(" AND UPPER(t1.CNAECTR93_056) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab04b56s00.getCnaectr93056().toUpperCase() + "%");
			} else {
				params.add(
						"%" + ab04b56s00.getCnaectr93056().toUpperCase() + "%");
			}
			where.append(" AND t1.CNAECTR93_056 IS NOT NULL");
		}
		if (ab04b56s00 != null && ab04b56s00.getCnaeemp93056() != null) {
			where.append(" AND UPPER(t1.CNAEEMP93_056) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab04b56s00.getCnaeemp93056().toUpperCase() + "%");
			} else {
				params.add(
						"%" + ab04b56s00.getCnaeemp93056().toUpperCase() + "%");
			}
			where.append(" AND t1.CNAEEMP93_056 IS NOT NULL");
		}
		if (ab04b56s00 != null && ab04b56s00.getModpre056() != null) {
			where.append(" AND t1.MODPRE_056 = ?");
			params.add(ab04b56s00.getModpre056());
		}
		if (ab04b56s00 != null && ab04b56s00.getNumcnt056() != null) {
			where.append(" AND t1.NUMCNT_056 = ?");
			params.add(ab04b56s00.getNumcnt056());
		}
		if (ab04b56s00 != null && ab04b56s00.getIdape056() != null) {
			where.append(" AND t1.IDAPE_056 = ?");
			params.add(ab04b56s00.getIdape056());
		}
		if (ab04b56s00 != null && ab04b56s00.getEvalpres056() != null) {
			where.append(" AND UPPER(t1.EVALPRES_056) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab04b56s00.getEvalpres056().toUpperCase() + "%");
			} else {
				params.add(
						"%" + ab04b56s00.getEvalpres056().toUpperCase() + "%");
			}
			where.append(" AND t1.EVALPRES_056 IS NOT NULL");
		}
		if (ab04b56s00 != null && ab04b56s00.getCanaleval056() != null) {
			where.append(" AND UPPER(t1.CANALEVAL_056) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab04b56s00.getCanaleval056().toUpperCase() + "%");
			} else {
				params.add(
						"%" + ab04b56s00.getCanaleval056().toUpperCase() + "%");
			}
			where.append(" AND t1.CANALEVAL_056 IS NOT NULL");
		}
		if (ab04b56s00 != null && ab04b56s00.getRegemp056() != null) {
			where.append(" AND UPPER(t1.REGEMP_056) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab04b56s00.getRegemp056().toUpperCase() + "%");
			} else {
				params.add("%" + ab04b56s00.getRegemp056().toUpperCase() + "%");
			}
			where.append(" AND t1.REGEMP_056 IS NOT NULL");
		}
		if (ab04b56s00 != null
				&& ab04b56s00.getNumdocrepresentante056() != null) {
			where.append(
					" AND UPPER(t1.NUMDOCREPRESENTANTE_056) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab04b56s00.getNumdocrepresentante056().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ ab04b56s00.getNumdocrepresentante056().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.NUMDOCREPRESENTANTE_056 IS NOT NULL");
		}
		if (ab04b56s00 != null
				&& ab04b56s00.getNombrerepresentante056() != null) {
			where.append(
					" AND UPPER(t1.NOMREPRESENTANTE_056) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab04b56s00.getNombrerepresentante056().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ ab04b56s00.getNombrerepresentante056().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.NOMREPRESENTANTE_056 IS NOT NULL");
		}
		if (ab04b56s00 != null
				&& ab04b56s00.getTipdocrepresentante056() != null) {
			where.append(
					" AND UPPER(t1.TIPDOCREPRESENTANTE_056) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab04b56s00.getTipdocrepresentante056().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ ab04b56s00.getTipdocrepresentante056().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.TIPDOCREPRESENTANTE_056 IS NOT NULL");
		}
		if (ab04b56s00 != null && ab04b56s00.getTlfrepresentante056() != null) {
			where.append(
					" AND UPPER(t1.TLFREPRESENTANTE_056) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab04b56s00.getTlfrepresentante056().toUpperCase()
						+ "%");
			} else {
				params.add(
						"%" + ab04b56s00.getTlfrepresentante056().toUpperCase()
								+ "%");
			}
			where.append(" AND t1.TLFREPRESENTANTE_056 IS NOT NULL");
		}
		if (ab04b56s00 != null && ab04b56s00.getTerape056() != null) {
			where.append(" AND UPPER(t1.TERAPE_056) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab04b56s00.getTerape056().toUpperCase() + "%");
			} else {
				params.add("%" + ab04b56s00.getTerape056().toUpperCase() + "%");
			}
			where.append(" AND t1.TERAPE_056 IS NOT NULL");
		}
		if (ab04b56s00 != null && ab04b56s00.getForpre056() != null) {
			where.append(" AND UPPER(t1.FORPRE_056) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab04b56s00.getForpre056().toUpperCase() + "%");
			} else {
				params.add("%" + ab04b56s00.getForpre056().toUpperCase() + "%");
			}
			where.append(" AND t1.FORPRE_056 IS NOT NULL");
		}
		if (ab04b56s00 != null && ab04b56s00.getFolderId056() != null) {
			where.append(" AND UPPER(t1.FOLDER_ID_056) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab04b56s00.getFolderId056().toUpperCase() + "%");
			} else {
				params.add(
						"%" + ab04b56s00.getFolderId056().toUpperCase() + "%");
			}
			where.append(" AND t1.FOLDER_ID_056 IS NOT NULL");
		}
		if (ab04b56s00 != null && ab04b56s00.getDatosNotificacion() != null
				&& ab04b56s00.getDatosNotificacion()
						.getCodDatosNotif066() != null) {
			where.append(" AND t1.COD_DATOS_NOTIF_056 = ?");
			params.add(ab04b56s00.getDatosNotificacion().getCodDatosNotif066());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	/**
	 * Finds rows in the ComunicacionApertura table for Reenvio de
	 * Comunicaciones.
	 * 
	 * comunicApertura ComunicacionApertura jqGridRequestDto JQGridRequestDto
	 * List
	 * 
	 * @param comunicApertura
	 *            the comunic apertura
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @return the list
	 */
	public List<ComunicacionApertura> findReenvioComunicaciones(
			ComunicacionApertura comunicApertura,
			JQGridRequestDto jqGridRequestDto) {
		return null;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * com.ejie.ab04b.dao.ComunicacionAperturaDao#updateFecFinPlazo(com.ejie
	 * .ab04b.model.ComunicacionApertura)
	 */
	@Override()
	public ComunicacionApertura updateFecFinPlazo(
			ComunicacionApertura ab04b56s00) {
		String query = "UPDATE AB0456S00 SET  FEC_FIN_PLAZO_056=? WHERE TERAPE_056=? AND ANOAPE_056=? AND NUMAPE_056=?";

		this.jdbcTemplate.update(query, ab04b56s00.getFecfinplazo056(),
				ab04b56s00.getTerape056(), ab04b56s00.getAnoape056(),
				ab04b56s00.getNumape056());

		return ab04b56s00;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * com.ejie.ab04b.dao.ComunicacionAperturaDao#updateUsuariosTramitacion(
	 * com.ejie.ab04b.model.ComunicacionApertura)
	 */
	@Override()
	public ComunicacionApertura updateUsuariosTramitacion(
			ComunicacionApertura apertura) {
		StringBuilder query = new StringBuilder("UPDATE AB0456S00 SET ");

		List<Object> params = new ArrayList<Object>();
		StringBuilder queryFields = new StringBuilder();

		if (apertura != null) {

			if (apertura.getUsuarioApe() != null) {
				queryFields.append(", USUARIO_APE_056 = ? ");
				params.add(apertura.getUsuarioApe());
			}

			if (apertura.getUsuarioAport() != null) {
				queryFields.append(", USUARIO_APORT_056 = ? ");
				params.add(apertura.getUsuarioAport());
			}

			if (apertura.getUsuarioTram() != null) {
				queryFields.append(", USUARIO_TRAM_056 = ? ");
				params.add(apertura.getUsuarioTram());
			}

			if (queryFields.length() > 0) {
				queryFields.deleteCharAt(0);
			}

		}

		query.append(queryFields);
		query.append(" WHERE TERAPE_056=? AND ANOAPE_056=? AND NUMAPE_056=?");

		params.add(apertura.getTerape056());
		params.add(apertura.getAnoape056());
		params.add(apertura.getNumape056());

		this.jdbcTemplate.update(query.toString(), params.toArray());
		return apertura;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * com.ejie.ab04b.dao.ComunicacionAperturaDao#findLastSSofNumDoc(com.ejie
	 * .ab04b.model.ComunicacionApertura)
	 */
	@Override()
	public ComunicacionApertura findLastSSofNumDoc(
			ComunicacionApertura filtro) {

		StringBuilder query = new StringBuilder(
				"SELECT t1.PRVSS_056 PRVSS056, t1.NUMSS_056 NUMSS056, t1.DIGSS_056 DIGSS056 ");

		query.append(" FROM AB0456S00 t1 ");
		query.append(
				" WHERE t1.TIPDOC_056 = ? and  t1.NUMDOC_056 = ? and t1.FECPRE_056 is not null and t1.FECPRE_056 is not null and t1.PRVSS_056 is not null and t1.NUMSS_056 is not null and t1.DIGSS_056 is not null and rownum=1 order by t1.FECPRE_056 ");

		List<ComunicacionApertura> ab04b56s00List = this.jdbcTemplate.query(
				query.toString(), this.rwMapSS, filtro.getTipdoc056(),
				filtro.getNumdoc056());
		return (ComunicacionApertura) DataAccessUtils
				.uniqueResult(ab04b56s00List);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * com.ejie.ab04b.dao.ComunicacionAperturaDao#findLastREAofNumDoc(com.ejie
	 * .ab04b.model.ComunicacionApertura)
	 */
	@Override()
	public ComunicacionApertura findLastREAofNumDoc(
			ComunicacionApertura filtro) {
		StringBuilder query = new StringBuilder(
				"SELECT T1.REGEMP_056 REGEMP056 ");

		query.append(" FROM AB0456S00 t1 ");
		query.append(
				" WHERE t1.TIPDOC_056 = ? and  t1.NUMDOC_056 = ? and t1.FECPRE_056 is not null and t1.FECPRE_056 is not null and t1.REGEMP_056 is not null and rownum=1 order by t1.FECPRE_056 ");

		List<ComunicacionApertura> ab04b56s00List = this.jdbcTemplate.query(
				query.toString(), this.rwMapRea, filtro.getTipdoc056(),
				filtro.getNumdoc056());
		return (ComunicacionApertura) DataAccessUtils
				.uniqueResult(ab04b56s00List);
	}

	/**
	 * Counts rows in the PORTAL table.
	 * 
	 * comunicacionApertura ComunicacionApertura Long
	 * 
	 * @param comunicacionApertura
	 *            the ab 04 b 56 s 00
	 * @return the long
	 */
	@Transactional(readOnly = true)
	public Long findCPenLocalidadCount(
			ComunicacionApertura comunicacionApertura) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM PORTAL ");

		query.append(" where COD_LOCALIDAD = ? and COD_POSTAL = ? ");

		List<Object> params = new ArrayList<Object>();
		params.add(comunicacionApertura.getDatosNotificacion()
				.getDatosLocalizacion().getLocalidad().getCodLocalidad());
		params.add(comunicacionApertura.getDatosNotificacion()
				.getDatosLocalizacion().getCodpostal067());

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	@Override()
	public void updateBatchSub(ComunicacionApertura apertura) {

		StringBuilder query = new StringBuilder(
				"UPDATE AB0456S00 SET IND_BATCH_SUB_056=0");

		List<Object> params = new ArrayList<Object>();

		query.append(" WHERE TERAPE_056=? AND ANOAPE_056=? AND NUMAPE_056=?");

		params.add(apertura.getTerape056());
		params.add(apertura.getAnoape056());
		params.add(apertura.getNumape056());

		this.jdbcTemplate.update(query.toString(), params.toArray());
	}

	@Override
	public void updateFecSub(ComunicacionApertura apertura) {
		StringBuilder query = new StringBuilder("UPDATE AB0456S00 SET ");

		List<Object> params = new ArrayList<Object>();
		StringBuilder queryFields = new StringBuilder();

		if (apertura != null) {

			if (apertura.getFecsub056() != null) {
				queryFields.append(", FECSUB_056 = ? ");
				params.add(apertura.getFecsub056());
			}

			if (queryFields.length() > 0) {
				queryFields.deleteCharAt(0);
			}

		}

		query.append(queryFields);
		query.append(" WHERE TERAPE_056=? AND ANOAPE_056=? AND NUMAPE_056=?");

		params.add(apertura.getTerape056());
		params.add(apertura.getAnoape056());
		params.add(apertura.getNumape056());

		this.jdbcTemplate.update(query.toString(), params.toArray());
	}
}
